/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.Checker;
import io.scif.DefaultChecker;
import io.scif.DefaultComponent;
import io.scif.DefaultMetadata;
import io.scif.DefaultParser;
import io.scif.DefaultReader;
import io.scif.DefaultWriter;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasFormat;
import io.scif.Metadata;
import io.scif.Parser;
import io.scif.Reader;
import io.scif.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFormat
extends AbstractSCIFIOPlugin
implements Format {
    private String[] suffixes;
    private boolean enabled = true;
    private Class<? extends Metadata> metadataClass = DefaultMetadata.class;
    private Class<? extends Checker> checkerClass = DefaultChecker.class;
    private Class<? extends Parser> parserClass = DefaultParser.class;
    private Class<? extends Reader> readerClass = DefaultReader.class;
    private Class<? extends Writer> writerClass = DefaultWriter.class;

    public AbstractFormat() {
        this.updateCustomClasses();
    }

    protected abstract String[] makeSuffixArray();

    @Override
    public String[] getSuffixes() {
        if (this.suffixes == null) {
            this.suffixes = this.makeSuffixArray();
        }
        return this.suffixes;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getFormatName() {
        return this.getInfo().getName();
    }

    @Override
    public Metadata createMetadata() throws FormatException {
        return this.createContextualObject(this.getMetadataClass());
    }

    @Override
    public Checker createChecker() throws FormatException {
        return this.createContextualObject(this.getCheckerClass());
    }

    @Override
    public Parser createParser() throws FormatException {
        return this.createContextualObject(this.getParserClass());
    }

    @Override
    public Reader createReader() throws FormatException {
        return this.createContextualObject(this.getReaderClass());
    }

    @Override
    public Writer createWriter() throws FormatException {
        return this.createContextualObject(this.getWriterClass());
    }

    public Class<? extends Metadata> getMetadataClass() {
        return this.metadataClass;
    }

    public Class<? extends Checker> getCheckerClass() {
        return this.checkerClass;
    }

    public Class<? extends Parser> getParserClass() {
        return this.parserClass;
    }

    public Class<? extends Reader> getReaderClass() {
        return this.readerClass;
    }

    public Class<? extends Writer> getWriterClass() {
        return this.writerClass;
    }

    private <T extends HasFormat> T createContextualObject(Class<T> c) throws FormatException {
        T t = this.createObject(c);
        t.setContext(this.getContext());
        if (DefaultComponent.class.isAssignableFrom(t.getClass())) {
            try {
                Field fmt = t.getClass().getDeclaredField("format");
                fmt.setAccessible(true);
                fmt.set(t, this);
            }
            catch (NoSuchFieldException e) {
                throw new FormatException("Failed to populate DefaultComponent field", e);
            }
            catch (SecurityException e) {
                throw new FormatException("Failed to populate DefaultComponent field", e);
            }
            catch (IllegalArgumentException e) {
                throw new FormatException("Failed to populate DefaultComponent field", e);
            }
            catch (IllegalAccessException e) {
                throw new FormatException("Failed to populate DefaultComponent field", e);
            }
        }
        return t;
    }

    private <T extends HasFormat> T createObject(Class<T> c) throws FormatException {
        try {
            return (T)((HasFormat)c.newInstance());
        }
        catch (InstantiationException e) {
            throw new FormatException(e);
        }
        catch (IllegalAccessException e) {
            throw new FormatException(e);
        }
    }

    private void updateCustomClasses() {
        for (Class<?> c : this.buildClassList()) {
            if (Metadata.class.isAssignableFrom(c)) {
                this.metadataClass = c;
                continue;
            }
            if (Checker.class.isAssignableFrom(c)) {
                this.checkerClass = c;
                continue;
            }
            if (Parser.class.isAssignableFrom(c)) {
                this.parserClass = c;
                continue;
            }
            if (Reader.class.isAssignableFrom(c)) {
                this.readerClass = c;
                continue;
            }
            if (!Writer.class.isAssignableFrom(c)) continue;
            this.writerClass = c;
        }
    }

    private List<Class<?>> buildClassList() {
        Class<?>[] classes = this.getClass().getDeclaredClasses();
        ArrayList classList = new ArrayList();
        for (Class<?> c : classes) {
            this.check(c, classList);
        }
        return classList;
    }

    private void check(Class<?> newClass, List<Class<?>> classList) {
        classList.add(newClass);
        for (Class<?> c : newClass.getDeclaredClasses()) {
            this.check(c, classList);
        }
    }
}

