/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import java.util.Random;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DrawingTool;
import net.imagej.axis.Axes;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.options.OptionsChannels;
import net.imagej.plugins.tools.SprayCanToolConfig;
import net.imagej.render.RenderingService;
import org.scijava.command.CommandService;
import org.scijava.display.event.input.MsDraggedEvent;
import org.scijava.display.event.input.MsEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;
import org.scijava.util.IntCoords;
import org.scijava.util.RealCoords;

@Plugin(type=Tool.class, name="SprayCan", label="Spray Can", description="Spray Can Tool", iconPath="/icons/tools/spray-can.png", priority=-303.0)
public class SprayCanTool
extends AbstractTool {
    public static final double PRIORITY = -303.0;
    @Parameter
    private CommandService commandService;
    @Parameter
    private OptionsService optionsService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private RenderingService renderingService;
    @Parameter(required=false)
    private EventService eventService;
    private DrawingTool drawingTool;
    private int width = 100;
    private int rate = 6;
    private int dotSize = 1;
    private long numPixels = 1L;
    private Random rng = new Random();

    public void onMouseDown(MsPressedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        if (!(evt.getDisplay() instanceof ImageDisplay)) {
            return;
        }
        this.initDrawingTool(evt);
        if (this.drawingTool != null) {
            this.numPixels = this.calcPixelCount();
            this.doOneSpray((MsEvent)evt);
        }
        evt.consume();
    }

    public void onMouseUp(MsReleasedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        if (this.drawingTool != null) {
            Dataset dataset = this.drawingTool.getDataset();
            if (this.eventService != null) {
                this.eventService.publish((SciJavaEvent)new DatasetUpdatedEvent(dataset, false));
            }
            this.drawingTool = null;
        }
        evt.consume();
    }

    public void onMouseDrag(MsDraggedEvent evt) {
        if (this.drawingTool == null) {
            return;
        }
        this.doOneSpray((MsEvent)evt);
        evt.consume();
    }

    public void configure() {
        this.commandService.run(SprayCanToolConfig.class, true, new Object[]{"tool", this});
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setDotSize(int dotSize) {
        this.dotSize = dotSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRate() {
        return this.rate;
    }

    public int getDotSize() {
        return this.dotSize;
    }

    private double calcFraction() {
        return 13.0 * Math.pow(2.02, this.rate - 1) / 7854.0;
    }

    private long calcPixelCount() {
        double fraction = this.calcFraction();
        long count = (long)(fraction * Math.PI * Math.pow((double)this.width / 2.0, 2.0));
        if (count <= 0L) {
            return 1L;
        }
        return count;
    }

    private void doOneSpray(MsEvent evt) {
        if (!(evt.getDisplay() instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay disp = (ImageDisplay)evt.getDisplay();
        ImageCanvas canv = disp.getCanvas();
        IntCoords panelCoords = new IntCoords(evt.getX(), evt.getY());
        RealCoords realCoords = canv.panelToDataCoords(panelCoords);
        this.drawPixels(realCoords.getLongX(), realCoords.getLongY());
        evt.getDisplay().update();
    }

    private void drawPixels(long ox, long oy) {
        double radius = (double)this.width / 2.0;
        double radius2 = radius * radius;
        int i = 0;
        while ((long)i < this.numPixels) {
            long dy;
            long dx;
            while ((double)((dx = (long)((this.rng.nextDouble() - 0.5) * (double)this.width)) * dx + (dy = (long)((this.rng.nextDouble() - 0.5) * (double)this.width)) * dy) > radius2) {
            }
            this.drawingTool.drawDot(ox + dx, oy + dy);
            ++i;
        }
    }

    private void initDrawingTool(MsPressedEvent evt) {
        ImageDisplay imageDisplay = (ImageDisplay)evt.getDisplay();
        if (imageDisplay == null) {
            return;
        }
        OptionsChannels options = (OptionsChannels)this.optionsService.getOptions(OptionsChannels.class);
        ChannelCollection channels = evt.getModifiers().isAltDown() || evt.getModifiers().isAltGrDown() ? options.getBgValues() : options.getFgValues();
        Dataset dataset = this.imageDisplayService.getActiveDataset(imageDisplay);
        this.drawingTool = new DrawingTool(dataset, this.renderingService);
        this.drawingTool.setChannels(channels);
        long[] currPos = new long[imageDisplay.numDimensions()];
        for (int i = 0; i < currPos.length; ++i) {
            currPos[i] = imageDisplay.getLongPosition(i);
        }
        this.drawingTool.setPosition(currPos);
        int chanIndex = imageDisplay.dimensionIndex(Axes.CHANNEL);
        if (chanIndex >= 0) {
            long currChanPos = currPos[chanIndex];
            this.drawingTool.setPreferredChannel(currChanPos);
        }
        this.drawingTool.setUAxis(0);
        this.drawingTool.setVAxis(1);
        this.drawingTool.setLineWidth((long)this.getDotSize());
    }
}

