/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.grab.script.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.scijava.grab.GrabService;
import org.scijava.log.LogService;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptModule;
import org.scijava.script.process.ScriptCallback;
import org.scijava.script.process.ScriptProcessor;

@Plugin(type=ScriptProcessor.class)
public class GrabScriptProcessor
implements ScriptProcessor {
    @Parameter
    private GrabService grabService;
    @Parameter
    private ParseService parser;
    @Parameter
    private LogService log;
    private ScriptInfo info;
    private List<String> grabArgs;
    private List<String> resolveArgs;

    public void begin(ScriptInfo scriptInfo) {
        this.info = scriptInfo;
    }

    public String process(String line) {
        if (!line.matches("(?i)^#@ *(dependency|repository)\\(.*")) {
            return line;
        }
        int paren = line.indexOf(40);
        String directive = line.substring(2, paren).toLowerCase();
        String arg = line.substring(paren);
        switch (directive) {
            case "dependency": {
                if (this.grabArgs == null) {
                    this.grabArgs = new ArrayList<String>();
                }
                this.grabArgs.add(arg);
                break;
            }
            case "repository": {
                if (this.resolveArgs == null) {
                    this.resolveArgs = new ArrayList<String>();
                }
                this.resolveArgs.add(arg);
            }
        }
        return "";
    }

    public void end() {
        if (this.grabArgs == null && this.resolveArgs == null) {
            return;
        }
        this.info.callbacks().add(new ScriptCallback(){

            public void invoke(ScriptModule module) throws ScriptException {
                if (GrabScriptProcessor.this.resolveArgs != null) {
                    for (String arg : GrabScriptProcessor.this.resolveArgs) {
                        GrabScriptProcessor.this.grabService.resolve((Map<String, Object>)GrabScriptProcessor.this.parser.parse(arg).asMap(), new Map[0]);
                    }
                }
                if (GrabScriptProcessor.this.grabArgs != null) {
                    for (String arg : GrabScriptProcessor.this.grabArgs) {
                        GrabScriptProcessor.this.grabService.grab(GrabScriptProcessor.this.parser.parse(arg).asMap());
                    }
                }
            }
        });
    }
}

