/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import net.imglib2.RealCursor;
import net.imglib2.img.Img;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;

public class ImgUtil {
    public static <T extends RealType<T>> void copy(double[] src, int offset, int[] stride, Img<T> dest) {
        RealCursor c = dest.localizingCursor();
        int[] location = new int[dest.numDimensions()];
        while (c.hasNext()) {
            RealType t = (RealType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            t.setReal(src[this_offset]);
        }
    }

    public static <T extends RealType<T>> void copy(float[] src, int offset, int[] stride, Img<T> dest) {
        RealCursor c = dest.localizingCursor();
        int[] location = new int[dest.numDimensions()];
        while (c.hasNext()) {
            RealType t = (RealType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            t.setReal(src[this_offset]);
        }
    }

    public static <T extends IntegerType<T>> void copy(long[] src, int offset, int[] stride, Img<T> dest) {
        RealCursor c = dest.localizingCursor();
        int[] location = new int[dest.numDimensions()];
        while (c.hasNext()) {
            IntegerType t = (IntegerType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            t.setInteger(src[this_offset]);
        }
    }

    public static <T extends IntegerType<T>> void copy(int[] src, int offset, int[] stride, Img<T> dest) {
        RealCursor c = dest.localizingCursor();
        int[] location = new int[dest.numDimensions()];
        while (c.hasNext()) {
            IntegerType t = (IntegerType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            t.setInteger(src[this_offset]);
        }
    }

    public static <T extends BooleanType<T>> void copy(boolean[] src, int offset, int[] stride, Img<T> dest) {
        RealCursor c = dest.localizingCursor();
        int[] location = new int[dest.numDimensions()];
        while (c.hasNext()) {
            BooleanType t = (BooleanType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            t.set(src[this_offset]);
        }
    }

    public static <T extends RealType<T>> void copy(Img<T> src, double[] dest, int offset, int[] stride) {
        RealCursor c = src.localizingCursor();
        int[] location = new int[src.numDimensions()];
        while (c.hasNext()) {
            RealType t = (RealType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            dest[this_offset] = t.getRealDouble();
        }
    }

    public static <T extends RealType<T>> void copy(Img<T> src, float[] dest, int offset, int[] stride) {
        RealCursor c = src.localizingCursor();
        int[] location = new int[src.numDimensions()];
        while (c.hasNext()) {
            RealType t = (RealType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            dest[this_offset] = t.getRealFloat();
        }
    }

    public static <T extends IntegerType<T>> void copy(Img<T> src, long[] dest, int offset, int[] stride) {
        RealCursor c = src.localizingCursor();
        int[] location = new int[src.numDimensions()];
        while (c.hasNext()) {
            IntegerType t = (IntegerType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            dest[this_offset] = t.getIntegerLong();
        }
    }

    public static <T extends IntegerType<T>> void copy(Img<T> src, int[] dest, int offset, int[] stride) {
        RealCursor c = src.localizingCursor();
        int[] location = new int[src.numDimensions()];
        while (c.hasNext()) {
            IntegerType t = (IntegerType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            dest[this_offset] = t.getInteger();
        }
    }

    public static <T extends BooleanType<T>> void copy(Img<T> src, boolean[] dest, int offset, int[] stride) {
        RealCursor c = src.localizingCursor();
        int[] location = new int[src.numDimensions()];
        while (c.hasNext()) {
            BooleanType t = (BooleanType)c.next();
            c.localize(location);
            int this_offset = offset;
            for (int i = 0; i < stride.length && i < location.length; ++i) {
                this_offset += location[i] * stride[i];
            }
            dest[this_offset] = t.get();
        }
    }
}

