/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class UnsignedShortType
extends GenericShortType<UnsignedShortType> {
    public UnsignedShortType(NativeImg<?, ? extends ShortAccess> img) {
        super(img);
    }

    public UnsignedShortType(int value) {
        super(UnsignedShortType.getCodedSignedShort(value));
    }

    public UnsignedShortType(ShortAccess access) {
        super(access);
    }

    public UnsignedShortType() {
        this(0);
    }

    public static short getCodedSignedShortChecked(int unsignedShort) {
        if (unsignedShort < 0) {
            unsignedShort = 0;
        } else if (unsignedShort > 65535) {
            unsignedShort = 65535;
        }
        return UnsignedShortType.getCodedSignedShort(unsignedShort);
    }

    public static short getCodedSignedShort(int unsignedShort) {
        return (short)(unsignedShort & 0xFFFF);
    }

    public static int getUnsignedShort(short signedShort) {
        return signedShort & 0xFFFF;
    }

    @Override
    public NativeImg<UnsignedShortType, ? extends ShortAccess> createSuitableNativeImg(NativeImgFactory<UnsignedShortType> storageFactory, long[] dim) {
        NativeImg<UnsignedShortType, ShortAccess> container = storageFactory.createShortInstance(dim, new Fraction());
        UnsignedShortType linkedType = new UnsignedShortType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedShortType duplicateTypeOnSameNativeImg() {
        return new UnsignedShortType(this.img);
    }

    @Override
    public void mul(float c) {
        this.set(Util.round((float)this.get() * c));
    }

    @Override
    public void mul(double c) {
        this.set((int)Util.round((double)this.get() * c));
    }

    @Override
    public void add(UnsignedShortType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedShortType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(UnsignedShortType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedShortType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public void inc() {
        this.set(this.get() + 1);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1);
    }

    public int get() {
        return UnsignedShortType.getUnsignedShort(this.getShort());
    }

    @Override
    public void set(int f) {
        this.setShort(UnsignedShortType.getCodedSignedShort(f));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.intValue());
    }

    @Override
    public double getMaxValue() {
        return 65535.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int hashCode() {
        return this.get();
    }

    @Override
    public int compareTo(UnsignedShortType c) {
        int b;
        int a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public UnsignedShortType createVariable() {
        return new UnsignedShortType(0);
    }

    @Override
    public UnsignedShortType copy() {
        return new UnsignedShortType(this.get());
    }

    @Override
    public String toString() {
        return "" + this.get();
    }
}

