/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericByteType<T extends GenericByteType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    int i = 0;
    protected final NativeImg<?, ? extends ByteAccess> img;
    protected ByteAccess dataAccess;

    public GenericByteType(NativeImg<?, ? extends ByteAccess> byteStorage) {
        this.img = byteStorage;
    }

    public GenericByteType(byte value) {
        this.img = null;
        this.dataAccess = new ByteArray(1);
        this.setByte(value);
    }

    public GenericByteType(ByteAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericByteType() {
        this(0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Deprecated
    protected byte getValue() {
        return this.dataAccess.getValue(this.i);
    }

    @Deprecated
    protected void setValue(byte f) {
        this.dataAccess.setValue(this.i, f);
    }

    public byte getByte() {
        return this.dataAccess.getValue(this.i);
    }

    public void setByte(byte f) {
        this.dataAccess.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        byte a = this.getByte();
        this.setByte((byte)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        byte a = this.getByte();
        this.setByte((byte)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a + ((GenericByteType)c).getByte()));
    }

    @Override
    public void div(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a / ((GenericByteType)c).getByte()));
    }

    @Override
    public void mul(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a * ((GenericByteType)c).getByte()));
    }

    @Override
    public void sub(T c) {
        byte a = this.getByte();
        this.setByte((byte)(a - ((GenericByteType)c).getByte()));
    }

    @Override
    public int hashCode() {
        return this.getByte();
    }

    @Override
    public int compareTo(T c) {
        byte b;
        byte a = this.getByte();
        if (a > (b = ((GenericByteType)c).getByte())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setByte(((GenericByteType)c).getByte());
    }

    @Override
    public void setOne() {
        this.setByte((byte)1);
    }

    @Override
    public void setZero() {
        this.setByte((byte)0);
    }

    @Override
    public void inc() {
        byte a = this.getByte();
        a = (byte)(a + 1);
        this.setByte(a);
    }

    @Override
    public void dec() {
        byte a = this.getByte();
        a = (byte)(a - 1);
        this.setByte(a);
    }

    @Override
    public String toString() {
        return "" + this.getByte();
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public int getBitsPerPixel() {
        return 8;
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getByte() == ((GenericByteType)t).getByte();
    }
}

