/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.type.AbstractBitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Util;

public abstract class AbstractIntegerBitType<T extends AbstractIntegerBitType<T>>
extends AbstractBitType<T>
implements IntegerType<T> {
    public AbstractIntegerBitType(NativeImg<?, ? extends LongAccess> bitStorage, int nBits) {
        super(bitStorage, nBits);
    }

    public abstract long get();

    @Override
    public abstract void set(long var1);

    @Override
    public int getBitsPerPixel() {
        return this.nBits;
    }

    @Override
    public double getMinIncrement() {
        return 1.0;
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealDouble() * (double)c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
    }

    @Override
    public float getRealFloat() {
        return this.getIntegerLong();
    }

    @Override
    public double getRealDouble() {
        return this.getIntegerLong();
    }

    @Override
    public void setReal(float real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setReal(double real) {
        this.setInteger(Util.round(real));
    }

    @Override
    public void setZero() {
        this.setInteger(0);
    }

    @Override
    public void setOne() {
        this.setInteger(1);
    }

    public boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        AbstractIntegerBitType t = (AbstractIntegerBitType)o;
        return this.compareTo((T)t) == 0;
    }

    public int hashCode() {
        long value = this.get();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public int compareTo(T c) {
        long b;
        long a = this.getIntegerLong();
        if (a > (b = ((AbstractIntegerBitType)c).getIntegerLong())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "" + this.getIntegerLong();
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public double getMaxValue() {
        return Math.pow(2.0, this.getBitsPerPixel()) - 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void inc() {
        this.set(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public void add(T t) {
        this.set(this.get() + ((AbstractIntegerBitType)t).get());
    }

    @Override
    public void sub(T t) {
        this.set(this.get() - ((AbstractIntegerBitType)t).get());
    }

    @Override
    public void mul(T t) {
        this.set(this.get() * ((AbstractIntegerBitType)t).get());
    }

    @Override
    public void div(T t) {
        this.set(this.get() / ((AbstractIntegerBitType)t).get());
    }

    @Override
    public void set(T c) {
        this.set(((AbstractIntegerBitType)c).get());
    }

    @Override
    public float getImaginaryFloat() {
        return 0.0f;
    }

    @Override
    public double getImaginaryDouble() {
        return 0.0;
    }

    @Override
    public void setImaginary(float complex) {
    }

    @Override
    public void setImaginary(double complex) {
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.setReal(r);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.setReal(r);
    }

    @Override
    public void complexConjugate() {
    }

    @Override
    public boolean valueEquals(T t) {
        return this.get() == ((AbstractIntegerBitType)t).get();
    }
}

