/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.AbstractBitType;

public abstract class AbstractBit64Type<T extends AbstractBit64Type<T>>
extends AbstractBitType<T> {
    private final long mask;
    private final long invMask;

    public AbstractBit64Type(NativeImg<?, ? extends LongAccess> bitStorage, int nBits) {
        super(bitStorage, nBits);
        if (nBits < 1 || nBits > 64) {
            throw new IllegalArgumentException("Supports only bit depths between 1 and 64, can't take " + nBits);
        }
        this.mask = nBits == 64 ? -1L : (long)(Math.pow(2.0, nBits) - 1.0);
        this.invMask = this.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public AbstractBit64Type(long value, int nBits) {
        this((NativeImg)null, nBits);
        this.updateIndex(0);
        this.dataAccess = new LongArray(1);
        this.setBits(value);
    }

    public AbstractBit64Type(LongAccess access, int nBits) {
        this((NativeImg)null, nBits);
        this.updateIndex(0);
        this.dataAccess = access;
    }

    public AbstractBit64Type(int nBits) {
        this(0L, nBits);
    }

    protected long getBits() {
        long k = this.i * (long)this.nBits;
        int i1 = (int)(k >>> 6);
        long shift = k & 0x3FL;
        long v = this.dataAccess.getValue(i1);
        if (0L == shift) {
            return v & this.mask;
        }
        long antiShift = 64L - shift;
        if (antiShift < (long)this.nBits) {
            long v1 = v >>> (int)shift & this.mask >>> (int)((long)this.nBits - antiShift);
            long v2 = (this.dataAccess.getValue(i1 + 1) & this.mask >>> (int)antiShift) << (int)antiShift;
            return v1 | v2;
        }
        return v >>> (int)shift & this.mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBits(long value) {
        long k = this.i * (long)this.nBits;
        int i1 = (int)(k >>> 6);
        long shift = k & 0x3FL;
        long safeValue = value & this.mask;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            if (0L == shift) {
                this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & this.invMask | safeValue);
            } else {
                long antiShift = 64L - shift;
                long v = this.dataAccess.getValue(i1);
                if (antiShift < (long)this.nBits) {
                    long v1 = v & -1L >>> (int)antiShift | (safeValue & this.mask >>> (int)((long)this.nBits - antiShift)) << (int)shift;
                    this.dataAccess.setValue(i1, v1);
                    long v2 = this.dataAccess.getValue(i1 + 1) & -1L << (int)((long)this.nBits - antiShift) | safeValue >>> (int)antiShift;
                    this.dataAccess.setValue(i1 + 1, v2);
                } else if (0L == v) {
                    this.dataAccess.setValue(i1, safeValue << (int)shift);
                } else {
                    this.dataAccess.setValue(i1, v & (this.mask << (int)shift ^ 0xFFFFFFFFFFFFFFFFL) | safeValue << (int)shift);
                }
            }
        }
    }
}

