/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.Positionable;

public final class SyncedPositionables {
    private SyncedPositionables() {
    }

    public static Positionable create(List<? extends Positionable> positionables) {
        switch (positionables.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return new Forwarder1(positionables);
            }
            case 2: {
                return new Forwarder2(positionables);
            }
            case 3: {
                return new Forwarder3(positionables);
            }
        }
        return new GeneralForwarder(positionables);
    }

    public static Positionable create(Positionable ... positionables) {
        return SyncedPositionables.create(Arrays.asList(positionables));
    }

    private static class GeneralForwarder
    implements Forwarder {
        private final Positionable[] values;

        public GeneralForwarder(List<? extends Positionable> values) {
            this.values = values.toArray(new Positionable[values.size()]);
        }

        @Override
        public void fwd(int d) {
            for (Positionable positionable : this.values) {
                positionable.fwd(d);
            }
        }

        @Override
        public void move(long offset, int d) {
            for (Positionable positionable : this.values) {
                positionable.move(offset, d);
            }
        }
    }

    private static class Forwarder3
    implements Forwarder {
        private final Positionable a;
        private final Positionable b;
        private final Positionable c;

        public Forwarder3(List<? extends Positionable> values) {
            this.a = values.get(0);
            this.b = values.get(1);
            this.c = values.get(2);
        }

        @Override
        public void fwd(int d) {
            this.a.fwd(d);
            this.b.fwd(d);
            this.c.fwd(d);
        }

        @Override
        public void move(long offset, int d) {
            this.a.move(offset, d);
            this.b.move(offset, d);
            this.c.move(offset, d);
        }
    }

    private static class Forwarder2
    implements Forwarder {
        private final Positionable a;
        private final Positionable b;

        public Forwarder2(List<? extends Positionable> values) {
            this.a = values.get(0);
            this.b = values.get(1);
        }

        @Override
        public void fwd(int d) {
            this.a.fwd(d);
            this.b.fwd(d);
        }

        @Override
        public void move(long offset, int d) {
            this.a.move(offset, d);
            this.b.move(offset, d);
        }
    }

    private static class Forwarder1
    implements Forwarder {
        private final Positionable a;

        public Forwarder1(List<? extends Positionable> values) {
            this.a = values.get(0);
        }

        @Override
        public void fwd(int d) {
            this.a.fwd(d);
        }

        @Override
        public void move(long offset, int d) {
            this.a.move(offset, d);
        }
    }

    private static interface Forwarder
    extends Positionable {
        @Override
        default public void bck(int d) {
            this.move(-1, d);
        }

        @Override
        default public void move(int distance, int d) {
            this.move((long)distance, d);
        }

        @Override
        default public void move(Localizable localizable) {
            for (int i = 0; i < localizable.numDimensions(); ++i) {
                this.move(localizable.getLongPosition(i), i);
            }
        }

        @Override
        default public void move(int[] distance) {
            for (int i = 0; i < distance.length; ++i) {
                this.move((long)distance[i], i);
            }
        }

        @Override
        default public void move(long[] distance) {
            for (int i = 0; i < distance.length; ++i) {
                this.move(distance[i], i);
            }
        }

        @Override
        default public void setPosition(Localizable localizable) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public void setPosition(int[] position) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public void setPosition(long[] position) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public void setPosition(int position, int d) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public void setPosition(long position, int d) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public int numDimensions() {
            throw new UnsupportedOperationException();
        }
    }
}

