/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.io.DataInputStream;
import java.io.IOException;

class ClassCopier<T> {
    private final Class<? extends T> original;
    private final byte[] bytes;

    public ClassCopier(Class<? extends T> original, Class<T> interfaceOfOriginal) {
        if (!interfaceOfOriginal.isAssignableFrom(original) || interfaceOfOriginal.equals(original)) {
            throw new IllegalArgumentException("\"original\" must be a implementation of interface \"interfaceOfOriginal\"");
        }
        this.original = original;
        this.bytes = this.classToBytes(original);
    }

    public Class<? extends T> copy() {
        System.err.println("Copy class: " + this.original);
        Class copy = new ClassCopyLoader().bytesToClass(this.original.getName(), this.bytes);
        return copy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] classToBytes(Class<?> aClass) {
        String className = aClass.getName();
        String classAsPath = className.replace('.', '/') + ".class";
        try (DataInputStream stream = new DataInputStream(aClass.getClassLoader().getResourceAsStream(classAsPath));){
            byte[] bytes = new byte[stream.available()];
            stream.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassCopyLoader
    extends ClassLoader {
        private ClassCopyLoader() {
        }

        private Class<?> bytesToClass(String className, byte[] bytes) {
            Class<?> copiedClass = super.defineClass(className, bytes, 0, bytes.length);
            super.resolveClass(copiedClass);
            return copiedClass;
        }
    }
}

