/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.neighborsearch;

import net.imglib2.RealPoint;
import net.imglib2.RealRandomAccess;
import net.imglib2.Sampler;
import net.imglib2.neighborsearch.KNearestNeighborSearch;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;

public class InverseDistanceWeightingInterpolator<T extends RealType<T>>
extends RealPoint
implements RealRandomAccess<T> {
    protected static final double minThreshold = 4.94E-321;
    protected final KNearestNeighborSearch<T> search;
    final T value;
    final int numNeighbors;
    final double p;
    final double p2;

    public InverseDistanceWeightingInterpolator(KNearestNeighborSearch<T> search, double p) {
        super(search.numDimensions());
        this.search = search;
        this.p = p;
        this.p2 = p / 2.0;
        search.search(this);
        this.value = (RealType)((RealType)search.getSampler(0).get()).copy();
        this.numNeighbors = search.getK();
    }

    @Override
    public T get() {
        this.search.search(this);
        if (this.numNeighbors == 1 || this.search.getSquareDistance(0) / this.search.getSquareDistance(1) < 4.94E-321) {
            this.value.set((Type)((Type)this.search.getSampler(0).get()));
        } else {
            Sampler<T> sampler;
            double sumIntensity = 0.0;
            double sumWeights = 0.0;
            for (int i = 0; i < this.numNeighbors && (sampler = this.search.getSampler(i)) != null; ++i) {
                RealType t = (RealType)sampler.get();
                double weight = this.computeWeight(this.search.getSquareDistance(i));
                sumWeights += weight;
                sumIntensity += t.getRealDouble() * weight;
            }
            this.value.setReal(sumIntensity / sumWeights);
        }
        return this.value;
    }

    protected double computeWeight(double squareDistance) {
        return 1.0 / Math.pow(squareDistance, this.p2);
    }

    @Override
    public InverseDistanceWeightingInterpolator<T> copy() {
        return new InverseDistanceWeightingInterpolator<T>(this.search.copy(), this.p);
    }

    @Override
    public InverseDistanceWeightingInterpolator<T> copyRealRandomAccess() {
        return this.copy();
    }
}

