/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Cursor;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.list.ListImg;
import net.imglib2.img.list.ListLocalizingCursor;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;

public class CellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    private final int[] defaultCellDimensions;

    public CellImgFactory() {
        this(10);
    }

    public CellImgFactory(int ... cellDimensions) {
        this.defaultCellDimensions = (int[])cellDimensions.clone();
        CellImgFactory.verifyDimensions(this.defaultCellDimensions);
    }

    public static void verifyDimensions(int[] dimensions) throws IllegalArgumentException {
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions == null");
        }
        if (dimensions.length == 0) {
            throw new IllegalArgumentException("dimensions.length == 0");
        }
        for (int d = 0; d < dimensions.length; ++d) {
            if (dimensions[d] > 0) continue;
            throw new IllegalArgumentException("dimensions[ " + d + " ] <= 0");
        }
    }

    public static void verifyDimensions(long[] dimensions) throws IllegalArgumentException {
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions == null");
        }
        if (dimensions.length == 0) {
            throw new IllegalArgumentException("dimensions.length == 0");
        }
        for (int d = 0; d < dimensions.length; ++d) {
            if (dimensions[d] > 0L) continue;
            throw new IllegalArgumentException("dimensions[ " + d + " ] <= 0");
        }
    }

    public static int[] getCellDimensions(int[] defaultCellDimensions, int n, Fraction entitiesPerPixel) throws IllegalArgumentException {
        int[] cellDimensions = new int[n];
        int max = defaultCellDimensions.length - 1;
        for (int i = 0; i < n; ++i) {
            cellDimensions[i] = defaultCellDimensions[i < max ? i : max];
        }
        long numEntities = entitiesPerPixel.mulCeil(Intervals.numElements(cellDimensions));
        if (numEntities > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of entities in cell too large. Use smaller cell size.");
        }
        return cellDimensions;
    }

    @Override
    public CellImg<T, ?> create(long[] dim, T type) {
        return (CellImg)type.createSuitableNativeImg(this, dim);
    }

    @Override
    public CellImg<T, ByteArray> createByteInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ByteArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, CharArray> createCharInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new CharArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, ShortArray> createShortInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ShortArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, IntArray> createIntInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new IntArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, LongArray> createLongInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new LongArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, FloatArray> createFloatInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new FloatArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public CellImg<T, DoubleArray> createDoubleInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new DoubleArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new CellImgFactory<T>(this.defaultCellDimensions);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    private <A extends ArrayDataAccess<A>> CellImg<T, A> createInstance(A creator, long[] dimensions, Fraction entitiesPerPixel) {
        CellImgFactory.verifyDimensions(dimensions);
        int n = dimensions.length;
        int[] cellDimensions = CellImgFactory.getCellDimensions(this.defaultCellDimensions, n, entitiesPerPixel);
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        long[] gridDimensions = new long[grid.numDimensions()];
        grid.gridDimensions(gridDimensions);
        Cell<Object> type = new Cell<Object>(new int[]{1}, new long[]{1L}, null);
        ListImg cells = new ListImg(gridDimensions, type);
        long[] cellGridPosition = new long[n];
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        Cursor cellCursor = cells.localizingCursor();
        while (((ListLocalizingCursor)cellCursor).hasNext()) {
            ((ListLocalizingCursor)cellCursor).fwd();
            ((AbstractLocalizableInt)((Object)cellCursor)).localize(cellGridPosition);
            grid.getCellDimensions(cellGridPosition, cellMin, cellDims);
            ArrayDataAccess data = (ArrayDataAccess)creator.createArray((int)entitiesPerPixel.mulCeil(Intervals.numElements(cellDims)));
            ((ListLocalizingCursor)cellCursor).set(new Cell<ArrayDataAccess>(cellDims, cellMin, data));
        }
        return new CellImg(this, grid, cells, entitiesPerPixel);
    }
}

