/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;

public class ArrayRandomAccess<T extends NativeType<T>>
extends AbstractLocalizableInt
implements RandomAccess<T> {
    protected final T type;
    final ArrayImg<T, ?> img;

    protected ArrayRandomAccess(ArrayRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.img = randomAccess.img;
        this.type = this.img.createLinkedType();
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = randomAccess.position[d];
            index += this.position[d] * this.img.steps[d];
        }
        this.type.updateContainer(this);
        this.type.updateIndex(index);
    }

    public ArrayRandomAccess(ArrayImg<T, ?> container) {
        super(container.numDimensions());
        this.img = container;
        this.type = container.createLinkedType();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
        this.type.updateIndex(0);
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public void fwd(int d) {
        this.type.incIndex(this.img.steps[d]);
        int n = d;
        this.position[n] = this.position[n] + 1;
    }

    @Override
    public void bck(int d) {
        this.type.decIndex(this.img.steps[d]);
        int n = d;
        this.position[n] = this.position[n] - 1;
    }

    @Override
    public void move(int distance, int d) {
        this.type.incIndex(this.img.steps[d] * distance);
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(long distance, int d) {
        this.type.incIndex(this.img.steps[d] * (int)distance);
        int n = d;
        this.position[n] = (int)((long)this.position[n] + distance);
    }

    @Override
    public void move(Localizable localizable) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            int distance = localizable.getIntPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            index += distance * this.img.steps[d];
        }
        this.type.incIndex(index);
    }

    @Override
    public void move(int[] distance) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            index += distance[d] * this.img.steps[d];
        }
        this.type.incIndex(index);
    }

    @Override
    public void move(long[] distance) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = (int)((long)this.position[n] + distance[d]);
            index = (int)((long)index + distance[d] * (long)this.img.steps[d]);
        }
        this.type.incIndex(index);
    }

    @Override
    public void setPosition(Localizable localizable) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getIntPosition(d);
            index += this.position[d] * this.img.steps[d];
        }
        this.type.updateIndex(index);
    }

    @Override
    public void setPosition(int[] pos) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
            index += pos[d] * this.img.steps[d];
        }
        this.type.updateIndex(index);
    }

    @Override
    public void setPosition(long[] pos) {
        int index = 0;
        for (int d = 0; d < this.n; ++d) {
            int p;
            this.position[d] = p = (int)pos[d];
            index += p * this.img.steps[d];
        }
        this.type.updateIndex(index);
    }

    @Override
    public void setPosition(int pos, int d) {
        this.type.incIndex((pos - this.position[d]) * this.img.steps[d]);
        this.position[d] = pos;
    }

    @Override
    public void setPosition(long pos, int d) {
        this.type.incIndex(((int)pos - this.position[d]) * this.img.steps[d]);
        this.position[d] = (int)pos;
    }

    @Override
    public ArrayRandomAccess<T> copy() {
        return new ArrayRandomAccess<T>(this);
    }

    @Override
    public ArrayRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public void fwdDim0() {
        this.type.incIndex();
        this.position[0] = this.position[0] + 1;
    }

    public void bckDim0() {
        this.type.decIndex();
        this.position[0] = this.position[0] - 1;
    }

    public void moveDim0(int distance) {
        this.type.incIndex(distance);
        this.position[0] = this.position[0] + distance;
    }

    public void move(long distance) {
        this.type.incIndex((int)distance);
        this.position[0] = (int)((long)this.position[0] + distance);
    }

    public void setPositionDim0(int pos) {
        this.type.updateIndex(pos);
        this.position[0] = pos;
    }

    public void setPositionDim0(long pos) {
        this.type.updateIndex((int)pos);
        this.position[0] = (int)pos;
    }
}

