/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.options;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.module.MutableModuleItem;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.ui.viewer.DisplayViewer;
import org.scijava.widget.UIComponent;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Look and Feel...", weight=100.0, mnemonic=108)})
public class OptionsLookAndFeel
extends OptionsPlugin {
    private static final String LOOK_AND_FEEL = "lookAndFeel";
    @Parameter
    private LogService log;
    @Parameter(label="Look & Feel", persist=false, initializer="initLookAndFeel")
    private String lookAndFeel;

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public void run() {
        UIManager.LookAndFeelInfo[] lookAndFeels;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equals(this.lookAndFeel)) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsLookAndFeel.this.refreshSwingComponents();
                    }
                });
            }
            catch (ClassNotFoundException e) {
                this.log.error((Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error((Throwable)e);
            }
            catch (UnsupportedLookAndFeelException e) {
                this.log.error((Throwable)e);
            }
            break;
        }
        super.run();
    }

    protected void initLookAndFeel() {
        String lafClass = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        ArrayList<String> lookAndFeelChoices = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo lafInfo : lookAndFeels) {
            String lafName = lafInfo.getName();
            lookAndFeelChoices.add(lafInfo.getName());
            if (!lafClass.equals(lafInfo.getClassName())) continue;
            this.lookAndFeel = lafName;
        }
        MutableModuleItem lookAndFeelItem = this.getInfo().getMutableInput(LOOK_AND_FEEL, String.class);
        lookAndFeelItem.setChoices(lookAndFeelChoices);
    }

    private void refreshSwingComponents() {
        HashSet<Component> components = new HashSet<Component>();
        for (UserInterface ui : this.uiService().getVisibleUIs()) {
            this.findComponents(components, ui.getApplicationFrame());
            this.findComponents(components, ui.getConsolePane());
        }
        for (Display d : this.displayService().getDisplays()) {
            DisplayViewer viewer = this.uiService().getDisplayViewer(d);
            if (viewer == null) continue;
            this.findComponents(components, viewer.getWindow());
        }
        for (Component c : components) {
            SwingUtilities.updateComponentTreeUI(c);
            if (!(c instanceof Window)) continue;
            ((Window)c).pack();
        }
    }

    private void findComponents(Set<Component> set, Object o) {
        Object c;
        if (o == null) {
            return;
        }
        if (o instanceof UIComponent) {
            c = (UIComponent)o;
            this.findComponents(set, c.getComponent());
        }
        if (o instanceof Window) {
            set.add((Window)o);
        } else if (o instanceof Component) {
            c = (Component)o;
            Window w = SwingUtilities.getWindowAncestor((Component)c);
            set.add((Component)(w == null ? c : w));
        }
    }

    private UIService uiService() {
        return (UIService)this.getContext().service(UIService.class);
    }

    private DisplayService displayService() {
        return (DisplayService)this.getContext().service(DisplayService.class);
    }

    @Deprecated
    public UserInterface getUI() {
        return this.uiService().getDefaultUI();
    }

    @Deprecated
    public void setUI(UserInterface ui) {
        throw new UnsupportedOperationException();
    }
}

