/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import org.scijava.console.OutputEvent;
import org.scijava.console.OutputListener;
import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.StaticSwingUtils;

@IgnoreAsCallingClass
public class ConsolePanel
extends JPanel
implements OutputListener {
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private StyledDocument doc;
    private Style stdoutLocal;
    private Style stderrLocal;
    private Style stdoutGlobal;
    private Style stderrGlobal;
    private final ThreadService threadService;

    public ConsolePanel(ThreadService threadService) {
        this.threadService = threadService;
        this.initGui();
    }

    public void clear() {
        this.textPane.setText("");
    }

    public void outputOccurred(final OutputEvent event) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                boolean atBottom = StaticSwingUtils.isScrolledToBottom(ConsolePanel.this.scrollPane);
                try {
                    ConsolePanel.this.doc.insertString(ConsolePanel.this.doc.getLength(), event.getOutput(), ConsolePanel.this.getStyle(event));
                }
                catch (BadLocationException exc) {
                    throw new RuntimeException(exc);
                }
                if (atBottom) {
                    StaticSwingUtils.scrollToBottom(ConsolePanel.this.scrollPane);
                }
            }
        });
    }

    private synchronized void initGui() {
        this.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill,align top]"));
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.stdoutLocal = this.createStyle("stdoutLocal", null, Color.black, null, null);
        this.stderrLocal = this.createStyle("stderrLocal", null, Color.red, null, null);
        this.stdoutGlobal = this.createStyle("stdoutGlobal", this.stdoutLocal, null, null, true);
        this.stderrGlobal = this.createStyle("stderrGlobal", this.stderrLocal, null, null, true);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add(this.textPane);
        this.scrollPane = new JScrollPane(textPanel);
        this.scrollPane.setPreferredSize(new Dimension(600, 600));
        FontMetrics fm = this.scrollPane.getFontMetrics(this.scrollPane.getFont());
        int charWidth = fm.charWidth('a');
        int lineHeight = fm.getHeight();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(charWidth);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(2 * lineHeight);
        this.add(this.scrollPane);
    }

    private Style createStyle(String name, Style parent, Color foreground, Boolean bold, Boolean italic) {
        Style style = this.textPane.addStyle(name, parent);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        if (bold != null) {
            StyleConstants.setBold(style, bold);
        }
        if (italic != null) {
            StyleConstants.setItalic(style, italic);
        }
        return style;
    }

    private Style getStyle(OutputEvent event) {
        boolean stderr = event.getSource() == OutputEvent.Source.STDERR;
        boolean contextual = event.isContextual();
        if (stderr) {
            return contextual ? this.stderrLocal : this.stderrGlobal;
        }
        return contextual ? this.stdoutLocal : this.stdoutGlobal;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }
}

