/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealPoint;
import net.imglib2.realtransform.AbstractScale;

public class Scale
extends AbstractScale {
    protected final Scale inverse;

    protected Scale(double[] s, Scale inverse, RealPoint[] ds) {
        super(s, ds);
        this.inverse = inverse;
    }

    public Scale(double ... s) {
        super((double[])s.clone(), new RealPoint[s.length]);
        double[] si = new double[s.length];
        RealPoint[] dis = new RealPoint[s.length];
        for (int d = 0; d < s.length; ++d) {
            si[d] = 1.0 / s[d];
            RealPoint dd = new RealPoint(s.length);
            dd.setPosition(s[d], d);
            this.ds[d] = dd;
            RealPoint ddi = new RealPoint(s.length);
            ddi.setPosition(si[d], d);
            dis[d] = ddi;
        }
        this.inverse = new Scale(si, this, dis);
    }

    @Override
    public void set(double ... s) {
        for (int d = 0; d < s.length; ++d) {
            this.s[d] = s[d];
            this.inverse.s[d] = 1.0 / s[d];
            this.ds[d].setPosition(s[d], d);
            this.inverse.ds[d].setPosition(this.inverse.s[d], d);
        }
    }

    @Override
    public Scale inverse() {
        return this.inverse;
    }

    @Override
    public Scale copy() {
        return new Scale(this.s);
    }
}

