/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class DeformationFieldTransform<T extends RealType<T>>
implements RealTransform {
    private final RealRandomAccessible<T> defFieldReal;
    private final RealRandomAccess<T> defFieldAccess;
    private final int numDim;

    public DeformationFieldTransform(RandomAccessibleInterval<T> def) {
        this(Views.interpolate(def, (InterpolatorFactory)new NLinearInterpolatorFactory()));
    }

    public DeformationFieldTransform(RealRandomAccessible<T> defFieldReal) {
        this.defFieldReal = defFieldReal;
        this.numDim = defFieldReal.numDimensions() - 1;
        this.defFieldAccess = defFieldReal.realRandomAccess();
    }

    @Override
    public int numSourceDimensions() {
        return this.numDim;
    }

    @Override
    public int numTargetDimensions() {
        return this.numDim;
    }

    @Override
    public void apply(double[] source, double[] target) {
        int d;
        for (d = 0; d < target.length; ++d) {
            this.defFieldAccess.setPosition(source[d], d);
        }
        this.defFieldAccess.setPosition(0.0, this.numDim);
        System.arraycopy(source, 0, target, 0, source.length);
        d = 0;
        while (d < this.numDim) {
            int n = d++;
            target[n] = target[n] + ((RealType)this.defFieldAccess.get()).getRealDouble();
            this.defFieldAccess.fwd(this.numDim);
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        int d;
        for (d = 0; d < target.length; ++d) {
            this.defFieldAccess.setPosition(source[d], d);
        }
        this.defFieldAccess.setPosition(0.0, this.numDim);
        System.arraycopy(source, 0, target, 0, source.length);
        d = 0;
        while (d < this.numDim) {
            int n = d++;
            target[n] = (float)((double)target[n] + ((RealType)this.defFieldAccess.get()).getRealDouble());
            this.defFieldAccess.fwd(this.numDim);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        for (int d = 0; d < target.numDimensions(); ++d) {
            this.defFieldAccess.setPosition(source.getDoublePosition(d), d);
        }
        this.defFieldAccess.setPosition(0.0, this.numDim);
        double newpos = 0.0;
        for (int d = 0; d < this.numDim; ++d) {
            newpos = source.getDoublePosition(d) + ((RealType)this.defFieldAccess.get()).getRealDouble();
            target.setPosition(newpos, d);
            this.defFieldAccess.fwd(this.numDim);
        }
    }

    @Override
    public RealTransform copy() {
        return new DeformationFieldTransform<T>(this.defFieldReal);
    }
}

