/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.RealTransformRandomAccessible;

public class AffineRandomAccessible<T, R extends AffineGet>
extends RealTransformRandomAccessible<T, R> {
    public AffineRandomAccessible(RealRandomAccessible<T> source, R transformToSource) {
        super(source, transformToSource);
    }

    @Override
    public AffineRandomAccess randomAccess() {
        return new AffineRandomAccess();
    }

    @Override
    public AffineRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class AffineRandomAccess
    extends RealTransformRandomAccessible.RealTransformRandomAccess {
        final double[] move;

        protected AffineRandomAccess() {
            super(AffineRandomAccessible.this);
            this.move = new double[this.n];
            this.apply();
        }

        protected AffineRandomAccess(AffineRandomAccess a) {
            super(AffineRandomAccessible.this, a);
            this.move = new double[this.n];
        }

        protected void scaleMove(double distance, int d) {
            RealLocalizable dd = ((AffineGet)this.transformCopy).d(d);
            for (int ddd = 0; ddd < this.n; ++ddd) {
                this.move[ddd] = distance * dd.getDoublePosition(ddd);
            }
        }

        public void fwd(int d) {
            super.fwd(d);
            this.sourceAccess.move(((AffineGet)this.transformCopy).d(d));
        }

        public void bck(int d) {
            super.bck(d);
            this.scaleMove(-1.0, d);
            this.sourceAccess.move(this.move);
        }

        public void move(long distance, int d) {
            super.move(distance, d);
            this.scaleMove(distance, d);
            this.sourceAccess.move(this.move);
        }

        public void move(int distance, int d) {
            this.move((long)distance, d);
        }

        public void move(Localizable localizable) {
            super.move(localizable);
            this.apply();
        }

        public void move(int[] distance) {
            super.move(distance);
            this.apply();
        }

        public void move(long[] distance) {
            super.move(distance);
            this.apply();
        }

        public void setPosition(int[] pos) {
            super.setPosition(pos);
            this.apply();
        }

        public void setPosition(long[] pos) {
            super.setPosition(pos);
            this.apply();
        }

        public void setPosition(int position, int d) {
            this.setPosition((long)position, d);
        }

        public void setPosition(long pos, int d) {
            long distance = pos - this.position[d];
            this.move(distance, d);
        }

        public void setPosition(Localizable localizable) {
            localizable.localize(this.position);
            this.apply();
        }

        @Override
        public T get() {
            return this.sourceAccess.get();
        }

        @Override
        public AffineRandomAccess copy() {
            return new AffineRandomAccess(this);
        }

        @Override
        public AffineRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

