/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.labeling.BoundingBox;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.BoxCount.class)
public class BoxCount<B extends BooleanType<B>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<B>, List<ValuePair<DoubleType, DoubleType>>>
implements Ops.Topology.BoxCount {
    @Parameter(required=false, persist=false)
    private Long maxSize = 48L;
    @Parameter(required=false, persist=false)
    private Long minSize = 6L;
    @Parameter(required=false, persist=false)
    private Double scaling = 1.2;
    @Parameter(required=false, persist=false)
    private Long gridMoves = 0L;

    @Override
    public List<ValuePair<DoubleType, DoubleType>> calculate(RandomAccessibleInterval<B> input) {
        ArrayList<ValuePair<DoubleType, DoubleType>> points = new ArrayList<ValuePair<DoubleType, DoubleType>>();
        int dimensions = input.numDimensions();
        long[] sizes = new long[dimensions];
        long numTranslations = 1L + this.gridMoves;
        input.dimensions(sizes);
        long sectionSize = this.maxSize;
        while (sectionSize >= this.minSize) {
            long translationAmount = Math.max(1L, sectionSize / numTranslations);
            Stream<long[]> translations = BoxCount.translationStream(numTranslations, translationAmount, dimensions - 1, new long[dimensions]);
            LongStream foregroundCounts = BoxCount.countTranslatedGrids(input, translations, sizes, sectionSize);
            long foreground = foregroundCounts.min().orElse(0L);
            double logSize = -Math.log(sectionSize);
            double logCount = Math.log(foreground);
            ValuePair point = new ValuePair((Object)new DoubleType(logSize), (Object)new DoubleType(logCount));
            points.add((ValuePair<DoubleType, DoubleType>)point);
            sectionSize = (long)((double)sectionSize / this.scaling);
        }
        return points;
    }

    private static <B extends BooleanType<B>> LongStream countTranslatedGrids(RandomAccessibleInterval<B> input, Stream<long[]> translations, long[] sizes, long sectionSize) {
        int lastDimension = sizes.length - 1;
        LongType foreground = new LongType();
        long[] sectionPosition = new long[sizes.length];
        return translations.mapToLong(gridOffset -> {
            foreground.setZero();
            Arrays.fill(sectionPosition, 0L);
            BoxCount.countGrid(input, lastDimension, sizes, gridOffset, sectionPosition, sectionSize, foreground);
            return foreground.get();
        });
    }

    private static <B extends BooleanType<B>> IntervalView<B> sectionView(RandomAccessibleInterval<B> interval, long[] sizes, long[] coordinates, long sectionSize) {
        int n = sizes.length;
        long[] startPosition = IntStream.range(0, n).mapToLong(i -> Math.max(0L, coordinates[i])).toArray();
        long[] endPosition = IntStream.range(0, n).mapToLong(i -> Math.min(sizes[i] - 1L, coordinates[i] + sectionSize - 1L)).toArray();
        boolean badBox = IntStream.range(0, n).anyMatch(d -> startPosition[d] >= sizes[d] || endPosition[d] < 0L || endPosition[d] < startPosition[d]);
        if (badBox) {
            return null;
        }
        BoundingBox box = new BoundingBox(n);
        box.update(startPosition);
        box.update(endPosition);
        return Views.offsetInterval(interval, (Interval)box);
    }

    private static <B extends BooleanType<B>> boolean hasForeground(IntervalView<B> view) {
        Spliterator spliterator = view.spliterator();
        return StreamSupport.stream(spliterator, false).anyMatch(BooleanType::get);
    }

    private static <B extends BooleanType<B>> void countGrid(RandomAccessibleInterval<B> interval, int dimension, long[] sizes, long[] translation, long[] sectionPosition, long sectionSize, LongType foreground) {
        int p = 0;
        while ((long)p < sizes[dimension]) {
            sectionPosition[dimension] = translation[dimension] + (long)p;
            if (dimension == 0) {
                IntervalView<B> box = BoxCount.sectionView(interval, sizes, sectionPosition, sectionSize);
                if (box != null && BoxCount.hasForeground(box)) {
                    foreground.inc();
                }
            } else {
                BoxCount.countGrid(interval, dimension - 1, sizes, translation, sectionPosition, sectionSize, foreground);
            }
            p = (int)((long)p + sectionSize);
        }
    }

    private static Stream<long[]> translationStream(long numTranslations, long amount, int dimension, long[] translation) {
        Stream.Builder<long[]> builder = Stream.builder();
        BoxCount.generateTranslations(numTranslations, amount, dimension, translation, builder);
        return builder.build();
    }

    private static void generateTranslations(long numTranslations, long amount, int dimension, long[] translation, Stream.Builder<long[]> builder) {
        int t = 0;
        while ((long)t < numTranslations) {
            translation[dimension] = (long)(-t) * amount;
            if (dimension == 0) {
                builder.add((long[])translation.clone());
            } else {
                BoxCount.generateTranslations(numTranslations, amount, dimension - 1, translation, builder);
            }
            ++t;
        }
    }
}

