/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.thin;

import net.imagej.ops.morphology.thin.Abstract3x3NeighbourhoodThinning;
import net.imagej.ops.morphology.thin.ThinningStrategy;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.logic.BitType;
import org.scijava.plugin.Plugin;

@Plugin(type=ThinningStrategy.class, name="ZhangSuen")
public class ZhangSuenThinningStrategy
extends Abstract3x3NeighbourhoodThinning {
    public ZhangSuenThinningStrategy() {
    }

    public ZhangSuenThinningStrategy(boolean foreground) {
        super(foreground);
    }

    @Override
    public boolean removePixel(long[] position, RandomAccessible<BitType> accessible, int iteration) {
        RandomAccess access = accessible.randomAccess();
        access.setPosition(position);
        boolean[] vals = this.getNeighbourhood((RandomAccess<BitType>)access);
        int numForeground = 0;
        for (int i = 1; i < vals.length; ++i) {
            if (vals[i] != this.m_foreground) continue;
            ++numForeground;
        }
        if (2 > numForeground || numForeground > 6) {
            return false;
        }
        int numPatternSwitches = this.findPatternSwitches(vals);
        if (numPatternSwitches != 1) {
            return false;
        }
        if (iteration % 2 != 1) {
            return this.evenIteration(vals);
        }
        return this.oddIteration(vals);
    }

    private boolean evenIteration(boolean[] vals) {
        if (vals[1] != this.m_background && vals[3] != this.m_background && vals[5] != this.m_background) {
            return false;
        }
        return vals[3] == this.m_background || vals[5] == this.m_background || vals[7] == this.m_background;
    }

    private boolean oddIteration(boolean[] vals) {
        if (vals[1] != this.m_background && vals[3] != this.m_background && vals[7] != this.m_background) {
            return false;
        }
        return vals[1] == this.m_background || vals[5] == this.m_background || vals[7] == this.m_background;
    }

    @Override
    public ThinningStrategy copy() {
        return new ZhangSuenThinningStrategy(this.m_foreground);
    }
}

