/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.fillHoles;

import net.imagej.ops.Ops;
import net.imagej.ops.create.img.CreateImgFromDimsAndType;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.FillHoles.class)
public class DefaultFillHoles<T extends BooleanType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Morphology.FillHoles {
    @Parameter(required=false)
    private Shape structElement = new RectangleShape(1, false);
    private UnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createFunc;
    private BinaryComputerOp<RandomAccessibleInterval<T>, Localizable, RandomAccessibleInterval<T>> floodFillComp;

    @Override
    public void initialize() {
        this.createFunc = RAIs.function(this.ops(), CreateImgFromDimsAndType.class, (RandomAccessibleInterval)this.in(), new BitType());
        this.floodFillComp = Computers.binary(this.ops(), Ops.Morphology.FloodFill.class, RandomAccessibleInterval.class, this.in(), Localizable.class, new Object[]{this.structElement});
    }

    @Override
    public void compute(RandomAccessibleInterval<T> op, RandomAccessibleInterval<T> r) {
        IterableInterval iterOp = Views.flatIterable(op);
        IterableInterval iterR = Views.flatIterable(r);
        long[] dim = new long[r.numDimensions()];
        r.dimensions(dim);
        Cursor rc = iterR.cursor();
        Cursor opc = iterOp.localizingCursor();
        while (rc.hasNext()) {
            ((BooleanType)rc.next()).setOne();
        }
        rc.reset();
        while (rc.hasNext()) {
            rc.next();
            opc.next();
            if (!((BooleanType)rc.get()).get() || ((BooleanType)opc.get()).get()) continue;
            boolean border = false;
            for (int i = 0; i < r.numDimensions(); ++i) {
                if (rc.getLongPosition(i) != 0L && rc.getLongPosition(i) != dim[i] - 1L) continue;
                border = true;
                break;
            }
            if (!border) continue;
            this.floodFillComp.compute(op, (Localizable)rc, r);
        }
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<T> input) {
        return this.createFunc.calculate(input);
    }
}

