/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.imagej.ops.geom.geom3d.mesh.Facet;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imglib2.RealLocalizable;

public class DefaultMesh
implements Mesh,
Iterable<Facet> {
    private List<Facet> facets = new ArrayList<Facet>();
    private Set<RealLocalizable> vertices;
    private double area;
    private double epsilon;

    public DefaultMesh() {
        this.vertices = new LinkedHashSet<RealLocalizable>();
        this.area = 0.0;
    }

    public DefaultMesh(Set<RealLocalizable> vertices) {
        this.area = 0.0;
        this.vertices = vertices;
    }

    @Override
    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFaces(List<Facet> facets) {
        this.facets = facets;
    }

    public void addFace(TriangularFacet f) {
        if (f.getArea() > 0.0) {
            this.facets.add(f);
            this.area += f.getArea();
            this.vertices.addAll(f.getVertices());
        }
    }

    @Override
    public double getSurfaceArea() {
        return this.area;
    }

    @Override
    public Iterator<Facet> iterator() {
        return this.facets.iterator();
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public boolean triangularFacets() {
        return true;
    }

    @Override
    public Set<RealLocalizable> getVertices() {
        return this.vertices;
    }
}

