/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.DefaultMesh;
import net.imagej.ops.geom.geom3d.mesh.Horizon;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imagej.ops.geom.geom3d.mesh.Vertex;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.ConvexHull.class)
public class DefaultConvexHull3D
extends AbstractUnaryFunctionOp<Mesh, Mesh>
implements Ops.Geometric.ConvexHull {
    private final double DOUBLE_PREC = 2.220446049250313E-16;

    @Override
    public Mesh calculate(Mesh input) {
        DefaultMesh output = new DefaultMesh();
        LinkedHashSet<Vertex> vertices = new LinkedHashSet<Vertex>();
        for (RealLocalizable v : input.getVertices()) {
            vertices.add(new Vertex(v.getDoublePosition(0), v.getDoublePosition(1), v.getDoublePosition(2)));
        }
        ArrayList<TriangularFacet> facets = new ArrayList<TriangularFacet>();
        ArrayList<TriangularFacet> facetsWithPointInFront = new ArrayList<TriangularFacet>();
        double epsilon = this.computeHull(vertices, facets, facetsWithPointInFront);
        for (TriangularFacet f : facets) {
            output.addFace(f);
        }
        output.setEpsilon(epsilon);
        return output;
    }

    private double computeHull(Set<Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        double epsilon = this.createSimplex(vertices, facets, facetsWithPointInFront);
        while (!facetsWithPointInFront.isEmpty()) {
            this.replaceFacet(epsilon, vertices, facets, facetsWithPointInFront, facetsWithPointInFront.remove(0));
        }
        return epsilon;
    }

    private void replaceFacet(double epsilon, Set<Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsPointInFront, TriangularFacet facet) {
        Vertex v = facet.getMaximumDistanceVertex();
        Horizon horizon = this.computeHorizon(epsilon, vertices, facets, facetsPointInFront, facet, v);
        this.assignPointsToFacets(epsilon, vertices, this.createFacets(horizon, v), facets, facetsPointInFront);
    }

    private List<TriangularFacet> createFacets(Horizon horizon, Vertex vTop) {
        Vertex vRight;
        Vertex vLeft;
        ArrayList<TriangularFacet> newFacets = new ArrayList<TriangularFacet>();
        for (int i = 1; i < horizon.size(); ++i) {
            vLeft = horizon.getVertex(i - 1);
            vRight = horizon.getVertex(i);
            TriangularFacet f = new TriangularFacet(vRight, vTop, vLeft);
            this.setNeighborZero(f, (TriangularFacet)horizon.getNeighbor(i));
            newFacets.add(f);
        }
        vRight = horizon.getVertex(0);
        vLeft = horizon.getLastVertex();
        TriangularFacet f = new TriangularFacet(vRight, vTop, vLeft);
        this.setNeighborZero(f, (TriangularFacet)horizon.getNeighbor(0));
        newFacets.add(f);
        this.connectTriangles(newFacets);
        return newFacets;
    }

    private void connectTriangles(List<TriangularFacet> newFacets) {
        int lastFacetIndex = newFacets.size() - 1;
        for (int i = 1; i < lastFacetIndex; ++i) {
            newFacets.get(i).setNeighbor(1, newFacets.get(i + 1));
            newFacets.get(i).setNeighbor(2, newFacets.get(i - 1));
        }
        newFacets.get(0).setNeighbor(1, newFacets.get(1));
        newFacets.get(0).setNeighbor(2, newFacets.get(lastFacetIndex));
        newFacets.get(lastFacetIndex).setNeighbor(1, newFacets.get(0));
        newFacets.get(lastFacetIndex).setNeighbor(2, newFacets.get(newFacets.size() - 2));
    }

    private void setNeighborZero(TriangularFacet f, TriangularFacet n) {
        int vertexIndex = n.indexOfVertex(f.getVertex(2));
        n.replaceNeighbor(vertexIndex, f);
        f.setNeighbor(0, n);
    }

    private Horizon computeHorizon(double epsilon, Set<Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront, TriangularFacet frontFacet, Vertex vTop) {
        vertices.addAll(frontFacet.getVerticesInFront());
        facets.remove(frontFacet);
        Horizon h = new Horizon(frontFacet);
        TriangularFacet merge = this.nextFacetToMerge(epsilon, h, vTop);
        while (merge != null) {
            vertices.addAll(merge.getVerticesInFront());
            facets.remove(merge);
            facetsWithPointInFront.remove(merge);
            if (h.containsAll(merge.getVertices())) {
                this.updateNeighbors(frontFacet, merge);
                h.complexMerge(merge);
            } else {
                this.updateNeighbors(frontFacet, merge);
                h.simpleMerge(merge);
            }
            merge = this.nextFacetToMerge(epsilon, h, vTop);
        }
        return h;
    }

    private void updateNeighbors(TriangularFacet frontFacet, TriangularFacet merge) {
        for (TriangularFacet f : merge.getNeighbors()) {
            if (f.equals(frontFacet)) continue;
            f.replaceNeighbor(f.indexOfNeighbor(merge), frontFacet);
        }
    }

    private TriangularFacet nextFacetToMerge(double epsilon, Horizon frontFacet, Vertex vTop) {
        for (TriangularFacet f : frontFacet.getNeighbors()) {
            if (!(f.distanceToPlane(vTop) > epsilon)) continue;
            if (frontFacet.containsAll(f.getVertices())) {
                Vertex v0 = f.getVertex(0);
                Vertex v1 = f.getVertex(1);
                Vertex v2 = f.getVertex(2);
                int numEdges = 0;
                if (frontFacet.hasEdge(v0, v2)) {
                    ++numEdges;
                }
                if (frontFacet.hasEdge(v2, v1)) {
                    ++numEdges;
                }
                if (frontFacet.hasEdge(v1, v0)) {
                    ++numEdges;
                }
                if (numEdges == 1) continue;
            }
            return f;
        }
        return null;
    }

    private void assignPointsToFacets(double epsilon, Set<Vertex> vertices, List<TriangularFacet> newFacets, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        for (Vertex v : vertices) {
            Iterator<TriangularFacet> facetIt = newFacets.iterator();
            TriangularFacet maxFacet = null;
            double maxdis = epsilon;
            while (facetIt.hasNext()) {
                TriangularFacet f = facetIt.next();
                double distanceToPlane = f.distanceToPlane(v);
                if (!(distanceToPlane > maxdis)) continue;
                maxdis = distanceToPlane;
                maxFacet = f;
            }
            if (maxFacet == null) continue;
            maxFacet.setVertexInFront(v, maxdis);
            if (facetsWithPointInFront.contains(maxFacet)) continue;
            facetsWithPointInFront.add(maxFacet);
        }
        facets.addAll(newFacets);
        vertices.clear();
    }

    private double createSimplex(Set<Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        Pair<Double, Vertex[]> minMax = this.computeMinMax(vertices);
        double epsilon = (Double)minMax.getA();
        int i = this.getMaxDistPointIndex((Vertex[])minMax.getB());
        Vertex v0 = ((Vertex[])minMax.getB())[i];
        Vertex v1 = ((Vertex[])minMax.getB())[i + 3];
        vertices.remove((Object)v0);
        vertices.remove((Object)v1);
        Vertex v2 = this.getV2(epsilon, vertices, v0, v1);
        vertices.remove((Object)v2);
        Vertex v3 = this.getV3(epsilon, vertices, v0, v1, v2);
        vertices.remove((Object)v3);
        TriangularFacet f0 = new TriangularFacet(v0, v1, v2);
        if (f0.distanceToPlane(v3) > epsilon) {
            Vertex tmp = v1;
            v1 = v2;
            v2 = tmp;
            f0 = new TriangularFacet(v0, v1, v2);
        }
        assert (f0.distanceToPlane(v3) < epsilon);
        TriangularFacet f1 = new TriangularFacet(v1, v0, v3);
        TriangularFacet f2 = new TriangularFacet(v2, v1, v3);
        TriangularFacet f3 = new TriangularFacet(v0, v2, v3);
        f0.setNeighbor(0, f3);
        f0.setNeighbor(1, f1);
        f0.setNeighbor(2, f2);
        f1.setNeighbor(0, f2);
        f1.setNeighbor(1, f0);
        f1.setNeighbor(2, f3);
        f2.setNeighbor(0, f3);
        f2.setNeighbor(1, f0);
        f2.setNeighbor(2, f1);
        f3.setNeighbor(0, f1);
        f3.setNeighbor(1, f0);
        f3.setNeighbor(2, f2);
        assert (f0.distanceToPlane(v3) < epsilon);
        assert (f1.distanceToPlane(v2) < epsilon);
        assert (f2.distanceToPlane(v0) < epsilon);
        assert (f3.distanceToPlane(v1) < epsilon);
        ArrayList<TriangularFacet> newFacets = new ArrayList<TriangularFacet>();
        newFacets.add(f0);
        newFacets.add(f1);
        newFacets.add(f2);
        newFacets.add(f3);
        this.assignPointsToFacets(epsilon, vertices, newFacets, facets, facetsWithPointInFront);
        return epsilon;
    }

    private Vertex getV3(double epsilon, Set<Vertex> vertices, Vertex v0, Vertex v1, Vertex v2) {
        double distPlanePoint = epsilon;
        Vertex v3 = null;
        Vector3D d0 = v1.subtract((Vector)v0);
        Vector3D d1 = v2.subtract((Vector)v0);
        Vector3D normal = d0.crossProduct((Vector)d1).normalize();
        for (Vertex v : vertices) {
            double d = Math.abs(normal.dotProduct((Vector)v.subtract((Vector)v0)));
            if (!(d > distPlanePoint)) continue;
            distPlanePoint = d;
            v3 = v;
        }
        return v3;
    }

    private Vertex getV2(double epsilon, Set<Vertex> vertices, Vertex v0, Vertex v1) {
        Iterator<Vertex> it = vertices.iterator();
        double distLinePoint = epsilon;
        Vertex v2 = null;
        while (it.hasNext()) {
            Vector3D d1;
            Vertex v = it.next();
            Vector3D d0 = v.subtract((Vector)v1);
            double lengthSq = d0.crossProduct((Vector)(d1 = v.subtract((Vector)v0))).getNormSq();
            if (!(lengthSq > distLinePoint)) continue;
            distLinePoint = lengthSq;
            v2 = v;
        }
        return v2;
    }

    private int getMaxDistPointIndex(Vertex[] minMax) {
        double[] diff = new double[]{minMax[3].getX() - minMax[0].getX(), minMax[4].getY() - minMax[1].getY(), minMax[5].getZ() - minMax[2].getZ()};
        double max = 0.0;
        int imax = 0;
        for (int i = 0; i < diff.length; ++i) {
            if (!(diff[i] > max)) continue;
            max = diff[i];
            imax = i;
        }
        return imax;
    }

    private Pair<Double, Vertex[]> computeMinMax(Set<Vertex> vertices) {
        double maxZ;
        double maxY;
        double maxX;
        Vertex[] minMax = new Vertex[6];
        Iterator<Vertex> it = vertices.iterator();
        Vertex initPoint = it.next();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = initPoint;
        }
        double minX = maxX = initPoint.getX();
        double minY = maxY = initPoint.getY();
        double minZ = maxZ = initPoint.getZ();
        while (it.hasNext()) {
            Vertex v = it.next();
            if (v.getX() > maxX) {
                maxX = v.getX();
                minMax[3] = v;
            } else if (v.getX() < minX) {
                minX = v.getX();
                minMax[0] = v;
            }
            if (v.getY() > maxY) {
                maxY = v.getY();
                minMax[4] = v;
            } else if (v.getY() < minY) {
                minY = v.getY();
                minMax[2] = v;
            }
            if (v.getZ() > maxZ) {
                maxZ = v.getZ();
                minMax[5] = v;
                continue;
            }
            if (!(v.getZ() < minZ)) continue;
            minZ = v.getZ();
            minMax[3] = v;
        }
        double epsilon = 6.661338147750939E-16 * (Math.max(Math.abs(maxX), Math.abs(minX)) + Math.max(Math.abs(maxY), Math.abs(minY)) + Math.max(Math.abs(maxZ), Math.abs(minZ)));
        return new ValuePair((Object)epsilon, (Object)minMax);
    }
}

