/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Roundness.class, label="Geometric (2D): Roundness")
public class DefaultRoundness
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.Roundness {
    private UnaryFunctionOp<Polygon, DoubleType> areaFunc;
    private UnaryFunctionOp<Polygon, DoubleType> majorAxisFunc;

    @Override
    public void initialize() {
        this.areaFunc = RTs.function(this.ops(), Ops.Geometric.Size.class, this.in(), new Object[0]);
        this.majorAxisFunc = RTs.function(this.ops(), Ops.Geometric.MajorAxis.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Polygon input, DoubleType output) {
        output.set(4.0 * (this.areaFunc.calculate(input).getRealDouble() / (Math.PI * Math.pow(this.majorAxisFunc.calculate(input).getRealDouble(), 2.0))));
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

