/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.pad;

import net.imagej.ops.filter.pad.PaddingIntervalCentered;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public abstract class PadInputFFT<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends RandomAccessibleInterval<T>>
extends AbstractBinaryFunctionOp<I, Dimensions, O> {
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> obf = null;
    private BinaryFunctionOp<I, Dimensions, O> paddingIntervalCentered;
    private UnaryFunctionOp<Dimensions, long[][]> fftSizeOp;

    public OutOfBoundsFactory<T, RandomAccessibleInterval<T>> getObf() {
        return this.obf;
    }

    public void setObf(OutOfBoundsFactory<T, RandomAccessibleInterval<T>> obf) {
        this.obf = obf;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.paddingIntervalCentered = (BinaryFunctionOp)Functions.unary(this.ops(), PaddingIntervalCentered.class, Interval.class, RandomAccessibleInterval.class, new Object[]{Interval.class});
    }

    @Override
    public O calculate(I input, Dimensions paddedDimensions) {
        Dimensions paddedFFTInputDimensions;
        if (this.fftSizeOp != null) {
            long[][] sizes = this.fftSizeOp.calculate(paddedDimensions);
            paddedFFTInputDimensions = new FinalDimensions(sizes[0]);
        } else {
            paddedFFTInputDimensions = paddedDimensions;
        }
        if (this.obf == null) {
            this.obf = new OutOfBoundsConstantValueFactory(((ComplexType)Util.getTypeFromInterval(input)).createVariable());
        }
        Interval inputInterval = (Interval)this.paddingIntervalCentered.calculate(input, paddedFFTInputDimensions);
        return (O)Views.interval((RandomAccessible)Views.extend(input, this.obf), (Interval)inputInterval);
    }

    protected void setFFTSizeOp(UnaryFunctionOp<Dimensions, long[][]> fftSizeOp) {
        this.fftSizeOp = fftSizeOp;
    }
}

