/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.filter.AbstractFilterF;
import net.imagej.ops.filter.fft.CreateOutputFFTMethods;
import net.imagej.ops.filter.pad.PadInputFFTMethods;
import net.imagej.ops.filter.pad.PadShiftKernelFFTMethods;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import org.scijava.plugin.Parameter;

public abstract class AbstractFFTFilterF<I extends RealType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K>, C extends ComplexType<C> & NativeType<C>>
extends AbstractFilterF<I, O, K, C> {
    @Parameter(required=false)
    private ComplexType<C> fftType;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval<C>> createOp;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> filter;

    @Override
    public void initialize() {
        super.initialize();
        this.setPadOp(Functions.binary(this.ops(), PadInputFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true, this.getOBFInput()}));
        this.setPadKernelOp(Functions.binary(this.ops(), PadShiftKernelFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true}));
        if (this.fftType == null) {
            this.fftType = (ComplexType)this.ops().create().nativeType(ComplexFloatType.class);
        }
        this.createOp = Functions.unary(this.ops(), CreateOutputFFTMethods.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.fftType, true});
    }

    @Override
    public void computeFilter(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> output, long[] paddedSize) {
        RandomAccessibleInterval<C> fftInput = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<C> fftKernel = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        this.filter = this.createFilterComputer(input, kernel, fftInput, fftKernel, output, (Interval)input);
        this.filter.compute(input, kernel, output);
    }

    public abstract BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> var1, RandomAccessibleInterval<K> var2, RandomAccessibleInterval<C> var3, RandomAccessibleInterval<C> var4, RandomAccessibleInterval<O> var5, Interval var6);
}

