/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.widget;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.imagej.axis.TypedAxis;
import net.imagej.space.TypedSpace;
import net.imagej.ui.swing.widget.DimSelectionWidget;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingDimSelectionWidget
extends SwingInputWidget<TypedAxis[]>
implements DimSelectionWidget<JPanel> {
    @Parameter
    private LogService log;
    protected TypedAxis[] m_typedAxis;
    private List<JToggleButton> m_dimLabelButtonList;
    private Queue<JToggleButton> m_activeToogleButtonsQueue;
    private int m_maxNumDims;
    private int m_minNumDims;

    public TypedAxis[] getValue() {
        ArrayList<TypedAxis> selectedAxis = new ArrayList<TypedAxis>();
        for (int i = 0; i < this.m_dimLabelButtonList.size(); ++i) {
            JToggleButton axisButton = this.m_dimLabelButtonList.get(i);
            if (!axisButton.isSelected()) continue;
            selectedAxis.add(this.m_typedAxis[i]);
        }
        return selectedAxis.toArray(new TypedAxis[selectedAxis.size()]);
    }

    public void set(WidgetModel model) {
        super.set(model);
        this.setAxis();
        this.m_minNumDims = this.getMinDims();
        this.m_maxNumDims = this.getMaxDims();
        if (this.m_minNumDims > this.m_maxNumDims) {
            throw new IllegalArgumentException("Minimum can't be larger than maximum");
        }
        this.buildUI();
        this.refreshWidget();
    }

    protected void setAxis() {
        this.m_typedAxis = this.extractAxis(this.get());
        if (this.m_typedAxis == null) {
            this.log.debug((Object)"Input model doesn't have a TypedSpace");
            throw new IllegalArgumentException("Model doesn't have a TypedSpace<?>");
        }
    }

    private void buildUI() {
        this.m_dimLabelButtonList = new ArrayList<JToggleButton>(this.m_typedAxis.length);
        this.m_activeToogleButtonsQueue = new LinkedList<JToggleButton>();
        for (TypedAxis m_typedAxi : this.m_typedAxis) {
            DimensionSelectionToggleButton button = new DimensionSelectionToggleButton(m_typedAxi.type().getLabel());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingDimSelectionWidget.this.toogleButtonChanged(e);
                }
            });
            this.m_dimLabelButtonList.add(button);
            this.getComponent().add(button);
        }
        for (int i = 0; i < Math.min(this.m_dimLabelButtonList.size(), this.m_maxNumDims); ++i) {
            JToggleButton button = this.m_dimLabelButtonList.get(i);
            button.setSelected(true);
            this.m_activeToogleButtonsQueue.add(button);
        }
    }

    private int getMinDims() {
        String minDims = this.get().getItem().get("min_dims");
        return minDims == null ? 0 : Integer.parseInt(minDims);
    }

    private int getMaxDims() {
        String maxDims = this.get().getItem().get("max_dims");
        return maxDims == null ? Integer.MAX_VALUE : Integer.parseInt(maxDims);
    }

    private void toogleButtonChanged(ActionEvent e) {
        JToggleButton sourceButton = (JToggleButton)e.getSource();
        if (sourceButton.isSelected()) {
            if (this.m_activeToogleButtonsQueue.size() == this.m_maxNumDims) {
                this.m_activeToogleButtonsQueue.poll().setSelected(false);
            }
            this.m_activeToogleButtonsQueue.add(sourceButton);
        } else if (this.m_activeToogleButtonsQueue.size() > this.m_minNumDims) {
            this.m_activeToogleButtonsQueue.remove(e.getSource());
        } else {
            ((JToggleButton)e.getSource()).setSelected(true);
        }
        this.updateModel();
    }

    private TypedAxis[] extractAxis(WidgetModel model) {
        Module module = model.getModule();
        for (ModuleItem moduleItem : module.getInfo().inputs()) {
            if (!TypedSpace.class.isAssignableFrom(moduleItem.getType())) continue;
            TypedSpace space = (TypedSpace)moduleItem.getValue(module);
            TypedAxis[] axis = new TypedAxis[space.numDimensions()];
            for (int i = 0; i < space.numDimensions(); ++i) {
                axis[i] = (TypedAxis)space.axis(i);
            }
            return axis;
        }
        return null;
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(TypedAxis[].class) && this.extractAxis(model) != null;
    }

    public void doRefresh() {
        this.get().setValue((Object)this.getValue());
    }

    private class DimensionSelectionToggleButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;

        public DimensionSelectionToggleButton(String text) {
            super(text);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color oldC = g.getColor();
            if (this.isSelected()) {
                g.setColor(new Color(0, 109, 44));
            } else {
                g.setColor(new Color(204, 76, 2));
            }
            g.fillRect(this.getWidth() - 10, this.getHeight() - 10, 6, 6);
            g.setColor(oldC);
        }
    }
}

