/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class DiamondTipsNeighborhoodRandomAccess<T>
extends DiamondTipsNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    protected DiamondTipsNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory) {
        super(source, radius, factory, null);
    }

    protected DiamondTipsNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory, Interval interval) {
        super(source, radius, factory, interval);
    }

    private DiamondTipsNeighborhoodRandomAccess(DiamondTipsNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d++;
            this.currentPos[n] = this.currentPos[n] + distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long position;
            this.currentPos[d] = position = localizable.getLongPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    public DiamondTipsNeighborhoodRandomAccess<T> copy() {
        return new DiamondTipsNeighborhoodRandomAccess<T>(this);
    }

    public DiamondTipsNeighborhoodRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

