/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.dog;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class DifferenceOfGaussian {
    public static <I extends NumericType<I>, T extends NumericType<T> & NativeType<T>> void DoG(double[] sigmaSmaller, double[] sigmaLarger, RandomAccessible<I> input, RandomAccessibleInterval<T> dog, ExecutorService service) {
        NumericType type = (NumericType)Util.getTypeFromInterval(dog);
        Img g1 = Util.getArrayOrCellImgFactory(dog, (NativeType)((NativeType)type)).create(dog, (Object)type);
        long[] translation = new long[dog.numDimensions()];
        dog.min(translation);
        DifferenceOfGaussian.DoG(sigmaSmaller, sigmaLarger, input, Views.translate((RandomAccessibleInterval)g1, (long[])translation), dog, service);
    }

    public static <I extends NumericType<I>, T extends NumericType<T> & NativeType<T>> void DoG(double[] sigmaSmaller, double[] sigmaLarger, RandomAccessible<I> input, RandomAccessible<T> tmp, RandomAccessibleInterval<T> dog, ExecutorService service) {
        final IntervalView tmpInterval = Views.interval(tmp, dog);
        try {
            Gauss3.gauss(sigmaSmaller, input, tmpInterval, service);
            Gauss3.gauss(sigmaLarger, input, dog, service);
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
        final IterableInterval dogIterable = Views.iterable(dog);
        final IterableInterval tmpIterable = Views.iterable((RandomAccessibleInterval)tmpInterval);
        long size = dogIterable.size();
        int numThreads = Runtime.getRuntime().availableProcessors();
        int numTasks = numThreads <= 1 ? 1 : numThreads * 20;
        long taskSize = size / (long)numTasks;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            long thisTaskSize;
            final long l = (long)taskNum * taskSize;
            long l2 = thisTaskSize = taskNum == numTasks - 1 ? size - l : taskSize;
            if (dogIterable.iterationOrder().equals(tmpIterable.iterationOrder())) {
                futures.add(service.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        Cursor dogCursor = dogIterable.cursor();
                        Cursor tmpCursor = tmpIterable.cursor();
                        dogCursor.jumpFwd(l);
                        tmpCursor.jumpFwd(l);
                        int i = 0;
                        while ((long)i < thisTaskSize) {
                            ((NumericType)dogCursor.next()).sub(tmpCursor.next());
                            ++i;
                        }
                        return null;
                    }
                }));
                continue;
            }
            futures.add(service.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    Cursor dogCursor = dogIterable.localizingCursor();
                    RandomAccess tmpAccess = tmpInterval.randomAccess();
                    dogCursor.jumpFwd(l);
                    int i = 0;
                    while ((long)i < thisTaskSize) {
                        NumericType o = (NumericType)dogCursor.next();
                        tmpAccess.setPosition((Localizable)dogCursor);
                        o.sub(tmpAccess.get());
                        ++i;
                    }
                    return null;
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static double[][] computeSigmas(double imageSigma, double minf, double[] pixelSize, double sigma1, double sigma2) {
        int n = pixelSize.length;
        double k = sigma2 / sigma1;
        double[] sigmas1 = new double[n];
        double[] sigmas2 = new double[n];
        for (int d = 0; d < n; ++d) {
            double s1 = Math.max(minf * imageSigma, sigma1 / pixelSize[d]);
            double s2 = k * s1;
            sigmas1[d] = Math.sqrt(s1 * s1 - imageSigma * imageSigma);
            sigmas2[d] = Math.sqrt(s2 * s2 - imageSigma * imageSigma);
        }
        return new double[][]{sigmas1, sigmas2};
    }

    public static double computeMinIsotropicSigma(double imageSigma, double minf, double[] pixelSize) {
        int n = pixelSize.length;
        double s = pixelSize[0];
        for (int d = 1; d < n; ++d) {
            s = Math.max(s, pixelSize[d]);
        }
        return minf * imageSigma * s;
    }
}

