/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.Iterator;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.util.IntervalIndexer;

public final class PixelList
implements Iterable<Localizable> {
    private final RandomAccess<LongType> locationsAccess;
    private final long[] dimensions;
    private long headIndex;
    private final long[] tailPos;
    private long size;

    public PixelList(RandomAccess<LongType> locationsAccess, long[] dimensions) {
        this.locationsAccess = locationsAccess;
        this.dimensions = dimensions;
        this.headIndex = 0L;
        this.tailPos = new long[dimensions.length];
        this.size = 0L;
    }

    public PixelList(PixelList l) {
        this.locationsAccess = l.locationsAccess;
        this.dimensions = l.dimensions;
        this.headIndex = l.headIndex;
        this.tailPos = null;
        this.size = l.size;
    }

    public void addPosition(Localizable position) {
        if (this.size == 0L) {
            long i;
            position.localize(this.tailPos);
            this.headIndex = i = IntervalIndexer.positionToIndex((long[])this.tailPos, (long[])this.dimensions);
        } else {
            this.locationsAccess.setPosition(this.tailPos);
            position.localize(this.tailPos);
            long i = IntervalIndexer.positionToIndex((long[])this.tailPos, (long[])this.dimensions);
            ((LongType)this.locationsAccess.get()).set(i);
        }
        ++this.size;
    }

    public void merge(PixelList l) {
        if (this.size == 0L) {
            this.headIndex = l.headIndex;
            for (int i = 0; i < this.tailPos.length; ++i) {
                this.tailPos[i] = l.tailPos[i];
            }
        } else {
            this.locationsAccess.setPosition(this.tailPos);
            ((LongType)this.locationsAccess.get()).set(l.headIndex);
            for (int i = 0; i < this.tailPos.length; ++i) {
                this.tailPos[i] = l.tailPos[i];
            }
        }
        this.size += l.size;
    }

    @Override
    public Iterator<Localizable> iterator() {
        return new PixelListIterator();
    }

    public long size() {
        return this.size;
    }

    public void clear() {
        this.size = 0L;
    }

    public class PixelListIterator
    implements Iterator<Localizable> {
        private long i = 0L;
        private long nextIndex;
        private final long[] tmp;
        private final Point pos;

        public PixelListIterator() {
            this.nextIndex = PixelList.this.headIndex;
            this.tmp = new long[PixelList.this.dimensions.length];
            this.pos = new Point(PixelList.this.dimensions.length);
        }

        @Override
        public boolean hasNext() {
            return this.i < PixelList.this.size;
        }

        @Override
        public Localizable next() {
            ++this.i;
            IntervalIndexer.indexToPosition((long)this.nextIndex, (long[])PixelList.this.dimensions, (long[])this.tmp);
            this.pos.setPosition(this.tmp);
            PixelList.this.locationsAccess.setPosition(this.tmp);
            this.nextIndex = ((LongType)PixelList.this.locationsAccess.get()).get();
            return this.pos;
        }

        @Override
        public void remove() {
        }
    }
}

