/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.PrimitiveCall;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class DollarTranslator
extends FunctionCallTranslator {
    @Override
    public Symbol getName() {
        return Symbol.get("$");
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        Expression object2 = builder.translateExpression(context, (SEXP)call2.getArgument(0));
        Symbol index = this.toSymbol((SEXP)call2.getArgument(1));
        return new PrimitiveCall(call2, "$", builder.simplify(object2), new Constant(index));
    }

    private Symbol toSymbol(SEXP argument) {
        if (argument instanceof Symbol) {
            return (Symbol)argument;
        }
        if (argument.length() == 1 && argument instanceof StringVector) {
            StringVector vector2 = (StringVector)argument;
            return Symbol.get(vector2.getElementAsString(0));
        }
        throw new InvalidSyntaxException("Illegal index value: " + argument);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        builder.addStatement(new ExprStatement(this.translateToExpression(builder, context, call2)));
    }
}

