/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.configuration;

import com.twosigma.beakerx.kernel.Config;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.message.MessageSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class ScijavaKernelConfigurationFile
implements ConfigurationFile {
    @Parameter
    private transient LogService log;
    private final File configFile;
    private Config configuration;
    private final String logLevel;

    public ScijavaKernelConfigurationFile(Context context, String logLevel, Path connectionFile) {
        context.inject(this);
        this.configFile = connectionFile.toFile();
        this.logLevel = logLevel;
    }

    public Config getConfig() {
        if (this.configuration == null) {
            try {
                this.configuration = (Config)MessageSerializer.parse((String)new String(Files.readAllBytes(this.configFile.toPath())), Config.class);
            }
            catch (IOException ex) {
                this.log.error("Issue loading connection file : " + ex);
            }
        }
        return this.configuration;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

