/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel;

import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.message.Message;
import net.imagej.table.process.ResultsPostprocessor;
import org.scijava.Context;
import org.scijava.display.DisplayPostprocessor;
import org.scijava.jupyter.kernel.comm.ScijavaCommOpenHandler;
import org.scijava.jupyter.kernel.configuration.ScijavaKernelConfigurationFile;
import org.scijava.jupyter.kernel.evaluator.ScijavaEvaluator;
import org.scijava.jupyter.kernel.handler.ScijavaKernelInfoHandler;
import org.scijava.jupyter.service.JupyterService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SciJavaPlugin;

public class ScijavaKernel
extends Kernel {
    Context context;
    @Parameter
    private transient LogService log;
    private final ScijavaKernelConfigurationFile config;

    public ScijavaKernel(Context context, String id, ScijavaEvaluator evaluator, ScijavaKernelConfigurationFile config, KernelSocketsFactory kernelSocketsFactory) {
        super(id, (Evaluator)evaluator, kernelSocketsFactory);
        this.context = context;
        this.context.inject((Object)this);
        this.config = config;
        Kernel.showNullExecutionResult = false;
        this.setLogLevel(config.getLogLevel());
        this.log.info("Log level used is : " + this.config.getLogLevel());
        this.log.info("Scijava Kernel is started and ready to use.");
    }

    public CommOpenHandler getCommOpenHandler(Kernel kernel) {
        return new ScijavaCommOpenHandler((KernelFunctionality)kernel);
    }

    public KernelHandler<Message> getKernelInfoHandler(Kernel kernel) {
        return new ScijavaKernelInfoHandler((KernelFunctionality)kernel);
    }

    private void setLogLevel(String logLevel) {
        switch (logLevel) {
            case "debug": {
                this.log.setLevel(4);
                break;
            }
            case "error": {
                this.log.setLevel(1);
                break;
            }
            case "info": {
                this.log.setLevel(3);
                break;
            }
            case "none": {
                this.log.setLevel(0);
                break;
            }
            default: {
                this.log.setLevel(3);
            }
        }
    }

    public static void main(String ... args) {
        Context context = new Context();
        PluginService pluginService = context.service(PluginService.class);
        PluginInfo<SciJavaPlugin> display = pluginService.getPlugin(DisplayPostprocessor.class);
        PluginInfo<SciJavaPlugin> results = pluginService.getPlugin(ResultsPostprocessor.class);
        pluginService.removePlugin(display);
        pluginService.removePlugin(results);
        JupyterService jupyter = context.service(JupyterService.class);
        jupyter.runKernel(args);
        context.dispose();
    }
}

