/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.jupyter.service.JupyterService;
import org.scijava.jupyter.utils.JupyterUtil;
import org.scijava.jupyter.utils.ProcessUtil;
import org.scijava.jupyter.utils.SystemUtil;
import org.scijava.log.LogService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptService;

@Plugin(type=Command.class, menu={@Menu(label="Analyze"), @Menu(label="Jupyter Kernel"), @Menu(label="Install Scijava Kernel (only for debugging)")})
public class InstallScijavaKernel
implements Command {
    @Parameter
    private LogService log;
    @Parameter
    private transient ScriptService scriptService;
    @Parameter(required=true, label="Python binary")
    private File pythonBinaryPath;
    @Parameter(required=true, label="Log Level", choices={"debug", "error", "info", "none"})
    private String logLevel = "info";
    @Parameter(required=false, label="Additional JAVA classpath")
    private String classpath = "";
    @Parameter(required=false, label="Java Binary Path")
    private File javaBinaryPath = null;

    @Override
    public void run() {
        if (!this.pythonBinaryPath.isFile()) {
            this.log.error(this.pythonBinaryPath + " does not exist.");
        }
        this.log.info("Installing 'scijava' kernel.");
        String[] cmd = null;
        String sourceCode = null;
        Map<String, String> results = null;
        cmd = new String[]{this.pythonBinaryPath.toString(), "--version"};
        results = ProcessUtil.executeProcess(cmd, this.log);
        if (!results.get("output").contains("Python") && !results.get("error").contains("Python")) {
            this.log.error(this.pythonBinaryPath + " does not seem to be a valid Python executable.");
            this.log.error("Output : " + results.get("output"));
            this.log.error("Error : " + results.get("error"));
            return;
        }
        this.log.debug("Python found.");
        sourceCode = "import jupyter";
        results = ProcessUtil.executePythonCode(this.pythonBinaryPath, sourceCode, this.log);
        if (results.get("error").contains("ModuleNotFoundError")) {
            this.log.error("Jupyter does not seems to be installed.");
            this.log.error("Output : " + results.get("output"));
            this.log.error("Error : " + results.get("error"));
            return;
        }
        this.log.debug("Jupyter found.");
        Path kernelDir = Paths.get(System.getProperty("java.io.tmpdir"), "scijava");
        SystemUtil.deleteFolderRecursively(kernelDir, this.log);
        kernelDir.toFile().mkdir();
        try {
            Files.copy(this.getClass().getResourceAsStream("/logo-64x64.png"), Paths.get(kernelDir.toString(), "logo-64x64.png"), new CopyOption[0]);
            Files.copy(this.getClass().getResourceAsStream("/logo-32x32.png"), Paths.get(kernelDir.toString(), "logo-32x32.png"), new CopyOption[0]);
        }
        catch (IOException ex) {
            this.log.error(ex);
            return;
        }
        String JSONString = this.javaBinaryPath == null ? JupyterUtil.createKernelJSON(this.classpath, this.logLevel, null) : JupyterUtil.createKernelJSON(this.classpath, this.logLevel, this.javaBinaryPath.toString());
        Path kernelJSONPath = Paths.get(kernelDir.toString(), "kernel.json");
        try (FileWriter file = new FileWriter(kernelJSONPath.toFile());){
            file.write(JSONString);
            this.log.debug("kernel.json file : \n" + JSONString);
        }
        catch (IOException ex) {
            this.log.error(ex);
            return;
        }
        this.log.debug("Kernel generated.");
        sourceCode = "from jupyter_client.kernelspec import KernelSpecManager\n";
        sourceCode = sourceCode + "KernelSpecManager().install_kernel_spec(\"" + kernelDir.toAbsolutePath().toString().replace("\\", "\\\\") + "\", user=True, replace=True)\n";
        results = ProcessUtil.executePythonCode(this.pythonBinaryPath, sourceCode, this.log);
        if (results.get("output").toLowerCase().contains("error") || results.get("error").toLowerCase().contains("error")) {
            this.log.error("New kernel installation failed.");
            this.log.error("Output : " + results.get("output"));
            this.log.error("Error : " + results.get("error"));
            return;
        }
        this.log.debug("Kernel installed.");
        this.log.debug("Clean temporary files.");
        SystemUtil.deleteFolderRecursively(kernelDir, this.log);
        this.log.info("The kernel 'scijava' has been correctly installed.");
    }

    public static void main(String ... args) {
        Context context = new Context();
        LogService log = context.service(LogService.class);
        log.setLevel(3);
        JupyterService jupyter = context.service(JupyterService.class);
        jupyter.installKernel(args);
        context.dispose();
    }
}

