/*
 * Decompiled with CFR 0.152.
 */
package ij.notebook.converter;

import ij.ImagePlus;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.notebook.converter.NotebookConverters;
import org.scijava.notebook.converter.NotebookOutputConverter;
import org.scijava.notebook.converter.output.PNGImageNotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class ImagePlusToPNGNotebookConverter
extends NotebookOutputConverter<ImagePlus, PNGImageNotebookOutput> {
    @Parameter
    private LogService log;

    @Override
    public Class<ImagePlus> getInputType() {
        return ImagePlus.class;
    }

    @Override
    public Class<PNGImageNotebookOutput> getOutputType() {
        return PNGImageNotebookOutput.class;
    }

    @Override
    public PNGImageNotebookOutput convert(Object object) {
        ImagePlus imgPlus = (ImagePlus)object;
        String base64Image = NotebookConverters.toPNG(imgPlus.getBufferedImage());
        return new PNGImageNotebookOutput(base64Image);
    }
}

