/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.Styler;

public class ToolTips
implements MouseMotionListener {
    private final List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    private DataPoint dataPoint;
    private static final int MARGIN = 5;
    private double leftEdge;
    private double rightEdge;
    private double topEdge;
    private double bottomEdge;
    private final Styler styler;

    ToolTips(Styler styler) {
        this.styler = styler;
        this.dataPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.styler.isToolTipsEnabled()) {
            return;
        }
        DataPoint newPoint = null;
        int x = e.getX();
        int y = e.getY();
        for (DataPoint dataPoint : this.dataPointList) {
            if (!dataPoint.shape.contains(x, y)) continue;
            newPoint = dataPoint;
            break;
        }
        if (newPoint != null) {
            if (this.dataPoint != null && this.dataPoint.equals(newPoint)) {
                return;
            }
            this.dataPoint = newPoint;
            e.getComponent().repaint();
        } else if (this.dataPoint != null) {
            this.dataPoint = null;
            e.getComponent().repaint();
        }
    }

    void prepare(Graphics2D g) {
        if (!this.styler.isToolTipsEnabled()) {
            return;
        }
        this.dataPointList.clear();
        Rectangle clipBounds = g.getClipBounds();
        this.leftEdge = clipBounds.getX() + 5.0;
        this.rightEdge = clipBounds.getMaxX() - 10.0;
        this.topEdge = clipBounds.getY() + 5.0;
        this.bottomEdge = clipBounds.getMaxY() - 10.0;
    }

    public void paint(Graphics2D g) {
        if (!this.styler.isToolTipsEnabled()) {
            return;
        }
        if (this.dataPoint != null) {
            this.paintToolTip(g, this.dataPoint);
        }
    }

    void addData(double xOffset, double yOffset, String xValue, String yValue) {
        String label = this.getLabel(xValue, yValue);
        this.addData(xOffset, yOffset, label);
    }

    private void addData(double xOffset, double yOffset, String label) {
        DataPoint dp = new DataPoint(xOffset, yOffset, label);
        this.dataPointList.add(dp);
    }

    void addData(Shape shape, double xOffset, double yOffset, double width, String xValue, String yValue) {
        String label = this.getLabel(xValue, yValue);
        this.addData(shape, xOffset, yOffset, width, label);
    }

    void addData(Shape shape, double xOffset, double yOffset, double width, String label) {
        DataPoint dp = new DataPoint(shape, xOffset, yOffset, width, label);
        this.dataPointList.add(dp);
    }

    private String getLabel(String xValue, String yValue) {
        switch (this.styler.getToolTipType()) {
            case xAndYLabels: {
                return "(" + xValue + ", " + yValue + ")";
            }
            case xLabels: {
                return xValue;
            }
            case yLabels: {
                return yValue;
            }
        }
        return "";
    }

    private void paintToolTip(Graphics2D g, DataPoint dataPoint) {
        TextLayout textLayout = new TextLayout(dataPoint.label, this.styler.getToolTipFont(), new FontRenderContext(null, true, false));
        Rectangle2D annotationRectangle = textLayout.getBounds();
        double x = dataPoint.x + dataPoint.w / 2.0 - annotationRectangle.getWidth() / 2.0 - 5.0;
        double y = dataPoint.y - 15.0 - annotationRectangle.getHeight();
        double w = annotationRectangle.getWidth() + 10.0;
        double h = annotationRectangle.getHeight() + 10.0;
        double halfHeight = h / 2.0;
        g.setColor(this.styler.getToolTipHighlightColor());
        g.fill(dataPoint.shape);
        x = Math.max(x, this.leftEdge);
        x = Math.min(x, this.rightEdge - w);
        y = Math.max(y, this.topEdge);
        y = Math.min(y, this.bottomEdge - h);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(x, y, w, h);
        g.setColor(this.styler.getToolTipBackgroundColor());
        g.fill(rectangle);
        g.setStroke(ChartPart.SOLID_STROKE);
        g.setColor(this.styler.getToolTipBorderColor());
        g.draw(rectangle);
        Shape shape = textLayout.getOutline(null);
        g.setColor(this.styler.getChartFontColor());
        g.setFont(this.styler.getToolTipFont());
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(x + 5.0 - 1.0, y + 5.0 - 1.0 + halfHeight);
        g.transform(at);
        g.fill(shape);
        g.setTransform(orig);
    }

    public MouseMotionListener getMouseMotionListener() {
        return this;
    }

    static class DataPoint {
        private final String label;
        private final Shape shape;
        private final double x;
        private final double y;
        final double w;

        DataPoint(double x, double y, String label) {
            double halfSize = 7.5;
            double markerSize = 15.0;
            this.shape = new Ellipse2D.Double(x - halfSize, y - halfSize, markerSize, markerSize);
            this.x = x;
            this.y = y;
            this.w = 0.0;
            this.label = label;
        }

        DataPoint(Shape shape, double x, double y, double width, String label) {
            this.x = x;
            this.y = y;
            this.w = width;
            this.shape = shape;
            this.label = label;
        }
    }
}

