/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public class AxisPair<ST extends AxesChartStyler, S extends Series>
implements ChartPart {
    private final Chart<AxesChartStyler, AxesChartSeries> chart;
    private final Axis<AxesChartStyler, AxesChartSeries> xAxis;
    private final Axis<AxesChartStyler, AxesChartSeries> yAxis;
    private final TreeMap<Integer, Axis<AxesChartStyler, AxesChartSeries>> yAxisMap;
    private Axis<AxesChartStyler, AxesChartSeries> leftMainYAxis;
    private Axis<AxesChartStyler, AxesChartSeries> rightMainYAxis;
    private final Rectangle2D.Double leftYAxisBounds;
    private final Rectangle2D.Double rightYAxisBounds;

    public AxisPair(Chart<AxesChartStyler, AxesChartSeries> chart) {
        this.chart = chart;
        this.xAxis = new Axis(chart, Axis.Direction.X, 0);
        this.yAxis = new Axis(chart, Axis.Direction.Y, 0);
        this.yAxisMap = new TreeMap();
        this.yAxisMap.put(0, this.yAxis);
        this.leftYAxisBounds = new Rectangle2D.Double();
        this.rightYAxisBounds = new Rectangle2D.Double();
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D.Double bounds;
        double rightEnd;
        int chartPadding;
        this.prepareForPaint();
        this.leftMainYAxis = null;
        this.rightMainYAxis = null;
        AxesChartStyler styler = this.chart.getStyler();
        int paddingBetweenAxes = chartPadding = styler.getChartPadding();
        int tickMargin = styler.isYAxisTicksVisible() ? styler.getPlotMargin() : 0;
        this.leftYAxisBounds.width = 0.0;
        int leftCount = 0;
        double leftStart = chartPadding;
        for (Map.Entry<Integer, Axis<AxesChartStyler, AxesChartSeries>> e : this.yAxisMap.entrySet()) {
            Axis<AxesChartStyler, AxesChartSeries> ya = e.getValue();
            if (styler.getYAxisGroupPosistion(e.getKey()) == Styler.YAxisPosition.Right || e.getKey() == 0) continue;
            ya.preparePaint();
            Rectangle2D.Double bounds2 = (Rectangle2D.Double)ya.getBounds();
            bounds2.x = leftStart;
            ya.paint(g);
            double width = bounds2.getWidth();
            leftStart += (double)paddingBetweenAxes + width + (double)tickMargin;
            this.leftYAxisBounds.width += width;
            ++leftCount;
            this.leftMainYAxis = ya;
        }
        if (styler.getYAxisGroupPosistion(0) != Styler.YAxisPosition.Right) {
            this.yAxis.preparePaint();
            Rectangle2D.Double bounds3 = (Rectangle2D.Double)this.yAxis.getBounds();
            bounds3.x = leftStart;
            this.yAxis.paint(g);
            double width = bounds3.getWidth();
            leftStart += (double)paddingBetweenAxes + width + (double)tickMargin;
            this.leftYAxisBounds.width += width;
            ++leftCount;
            this.leftMainYAxis = this.yAxis;
        }
        if (leftCount > 1) {
            this.leftYAxisBounds.width += (double)((leftCount - 1) * paddingBetweenAxes);
        }
        this.leftYAxisBounds.width += (double)(leftCount * tickMargin);
        this.rightYAxisBounds.width = 0.0;
        double legendWidth = 0.0;
        if (styler.getLegendPosition() == Styler.LegendPosition.OutsideE && styler.isLegendVisible()) {
            legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)styler.getChartPadding();
        }
        this.rightYAxisBounds.x = rightEnd = (double)this.chart.getWidth() - legendWidth - (double)(1 * chartPadding);
        int rightCount = 0;
        for (Map.Entry e : this.yAxisMap.descendingMap().entrySet()) {
            double xOffset;
            Axis ya = (Axis)e.getValue();
            if (styler.getYAxisGroupPosistion((Integer)e.getKey()) != Styler.YAxisPosition.Right || (Integer)e.getKey() == 0) continue;
            ya.preparePaint();
            Rectangle2D.Double bounds4 = (Rectangle2D.Double)ya.getBounds();
            double aproxWidth = bounds4.getWidth();
            bounds4.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            ya.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            rightEnd -= (double)paddingBetweenAxes + aproxWidth + (double)tickMargin;
            ++rightCount;
            this.rightMainYAxis = ya;
        }
        if (styler.getYAxisGroupPosistion(0) == Styler.YAxisPosition.Right) {
            double xOffset;
            this.yAxis.preparePaint();
            bounds = (Rectangle2D.Double)this.yAxis.getBounds();
            double aproxWidth = bounds.getWidth();
            bounds.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            this.yAxis.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            rightEnd -= (double)paddingBetweenAxes + aproxWidth + (double)tickMargin;
            ++rightCount;
            this.rightMainYAxis = this.yAxis;
        }
        if (this.leftMainYAxis == null) {
            this.leftMainYAxis = this.yAxis;
        }
        if (this.rightMainYAxis == null) {
            this.rightMainYAxis = this.yAxis;
        }
        if (rightCount > 1) {
            this.rightYAxisBounds.width += (double)((rightCount - 1) * paddingBetweenAxes);
        }
        this.rightYAxisBounds.width += (double)(rightCount * tickMargin);
        bounds = (Rectangle2D.Double)this.yAxis.getBounds();
        this.leftYAxisBounds.x = chartPadding;
        this.leftYAxisBounds.y = bounds.y;
        this.leftYAxisBounds.height = bounds.height;
        this.rightYAxisBounds.y = bounds.y;
        this.rightYAxisBounds.height = bounds.height;
        this.xAxis.preparePaint();
        this.xAxis.paint(g);
    }

    private void prepareForPaint() {
        boolean mainYAxisUsed = false;
        if (this.chart.getSeriesMap() != null) {
            for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                int n = series.getYAxisGroup();
                if (!mainYAxisUsed && n == 0) {
                    mainYAxisUsed = true;
                }
                if (this.yAxisMap.containsKey(n)) continue;
                this.yAxisMap.put(n, new Axis(this.chart, Axis.Direction.Y, n));
            }
        }
        this.xAxis.setAxisDataType(null);
        for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
            ya.setAxisDataType(null);
        }
        for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
            this.xAxis.setAxisDataType(series.getxAxisDataType());
            this.getYAxis(series.getYAxisGroup()).setAxisDataType(series.getyAxisDataType());
            if (mainYAxisUsed) continue;
            this.yAxis.setAxisDataType(series.getyAxisDataType());
        }
        this.xAxis.resetMinMax();
        for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
            ya.resetMinMax();
        }
        if (this.chart.getSeriesMap() == null || this.chart.getSeriesMap().size() < 1) {
            this.xAxis.addMinMax(-1.0, 1.0);
            for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
                ya.addMinMax(-1.0, 1.0);
            }
        } else {
            int disabledCount = 0;
            for (AxesChartSeries axesChartSeries : this.chart.getSeriesMap().values()) {
                if (!axesChartSeries.isEnabled()) {
                    ++disabledCount;
                    continue;
                }
                this.xAxis.addMinMax(axesChartSeries.getXMin(), axesChartSeries.getXMax());
                this.getYAxis(axesChartSeries.getYAxisGroup()).addMinMax(axesChartSeries.getYMin(), axesChartSeries.getYMax());
                if (mainYAxisUsed) continue;
                this.yAxis.addMinMax(axesChartSeries.getYMin(), axesChartSeries.getYMax());
            }
            if (disabledCount == this.chart.getSeriesMap().values().size()) {
                this.xAxis.addMinMax(-1.0, 1.0);
                for (Axis axis : this.yAxisMap.values()) {
                    axis.addMinMax(-1.0, 1.0);
                }
            }
        }
        this.overrideMinMaxForXAxis();
        for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
            this.overrideMinMaxForYAxis(ya);
        }
        if (this.chart.getStyler().isXAxisLogarithmic() && this.xAxis.getMin() <= 0.0) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic X-Axis!!!");
        }
        if (this.chart.getStyler().isYAxisLogarithmic()) {
            for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
                if (!(ya.getMin() <= 0.0)) continue;
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic Y-Axis!!!");
            }
        }
        if (this.xAxis.getMin() == Double.POSITIVE_INFINITY || this.xAxis.getMax() == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
        }
        for (Axis<AxesChartStyler, AxesChartSeries> ya : this.yAxisMap.values()) {
            if (ya.getMin() == Double.POSITIVE_INFINITY || ya.getMax() == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
            }
            if (ya.getMin() != Double.NEGATIVE_INFINITY && ya.getMax() != Double.NEGATIVE_INFINITY) continue;
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
        if (this.xAxis.getMin() == Double.NEGATIVE_INFINITY || this.xAxis.getMax() == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
    }

    protected Axis<AxesChartStyler, AxesChartSeries> getYAxis(int yIndex) {
        return this.yAxisMap.get(yIndex);
    }

    private void overrideMinMaxForXAxis() {
        double overrideXAxisMinValue = this.xAxis.getMin();
        double overrideXAxisMaxValue = this.xAxis.getMax();
        if (this.chart.getStyler().getXAxisMin() != null) {
            overrideXAxisMinValue = this.chart.getStyler().getXAxisMin();
        }
        if (this.chart.getStyler().getXAxisMax() != null) {
            overrideXAxisMaxValue = this.chart.getStyler().getXAxisMax();
        }
        this.xAxis.setMin(overrideXAxisMinValue);
        this.xAxis.setMax(overrideXAxisMaxValue);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideMinMaxForYAxis(Axis yAxis) {
        CategoryStyler categoryStyler;
        double overrideYAxisMinValue = yAxis.getMin();
        double overrideYAxisMaxValue = yAxis.getMax();
        if (this.chart.getStyler() instanceof CategoryStyler && (categoryStyler = (CategoryStyler)this.chart.getStyler()).getDefaultSeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar) {
            if (categoryStyler.isStacked()) {
                void var14_16;
                int numCategories = this.chart.getSeriesMap().values().iterator().next().getXData().size();
                double[] accumulatedStackOffsetPos = new double[numCategories];
                double[] accumulatedStackOffsetNeg = new double[numCategories];
                for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                    if (!series.isEnabled()) continue;
                    int categoryCounter = 0;
                    for (Number number : series.getYData()) {
                        if (number == null) {
                            ++categoryCounter;
                            continue;
                        }
                        if (number.doubleValue() > 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + number.doubleValue();
                        } else if (number.doubleValue() < 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + number.doubleValue();
                        }
                        ++categoryCounter;
                    }
                }
                double max = accumulatedStackOffsetPos[0];
                for (int i = 1; i < accumulatedStackOffsetPos.length; ++i) {
                    if (!(accumulatedStackOffsetPos[i] > max)) continue;
                    max = accumulatedStackOffsetPos[i];
                }
                double min = accumulatedStackOffsetNeg[0];
                boolean bl = true;
                while (var14_16 < accumulatedStackOffsetNeg.length) {
                    if (accumulatedStackOffsetNeg[var14_16] < min) {
                        min = accumulatedStackOffsetNeg[var14_16];
                    }
                    ++var14_16;
                }
                overrideYAxisMaxValue = max;
                overrideYAxisMinValue = min;
            }
            if (yAxis.getMin() > 0.0) {
                overrideYAxisMinValue = 0.0;
            }
            if (yAxis.getMax() < 0.0) {
                overrideYAxisMaxValue = 0.0;
            }
        }
        if (this.chart.getStyler().getYAxisMin() != null) {
            overrideYAxisMinValue = this.chart.getStyler().getYAxisMin();
        }
        if (this.chart.getStyler().getYAxisMax() != null) {
            overrideYAxisMaxValue = this.chart.getStyler().getYAxisMax();
        }
        yAxis.setMin(overrideYAxisMinValue);
        yAxis.setMax(overrideYAxisMaxValue);
    }

    Axis<AxesChartStyler, AxesChartSeries> getXAxis() {
        return this.xAxis;
    }

    Axis<AxesChartStyler, AxesChartSeries> getYAxis() {
        return this.yAxis;
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }

    public Rectangle2D.Double getLeftYAxisBounds() {
        return this.leftYAxisBounds;
    }

    public Rectangle2D.Double getRightYAxisBounds() {
        return this.rightYAxisBounds;
    }

    public Axis<AxesChartStyler, AxesChartSeries> getLeftMainYAxis() {
        return this.leftMainYAxis;
    }

    public Axis<AxesChartStyler, AxesChartSeries> getRightMainYAxis() {
        return this.rightMainYAxis;
    }
}

