/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.event.ContextDisposingEvent;
import org.scijava.event.EventHandler;
import org.scijava.io.IOService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugins.scripting.java.JavaEngine;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptHeaderService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.ui.CloseConfirmable;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.script.Bookmark;
import org.scijava.ui.swing.script.BookmarkDialog;
import org.scijava.ui.swing.script.DefaultAutoImporters;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.ErrorHandler;
import org.scijava.ui.swing.script.ExceptionHandler;
import org.scijava.ui.swing.script.FileFunctions;
import org.scijava.ui.swing.script.FindAndReplaceDialog;
import org.scijava.ui.swing.script.JTextAreaWriter;
import org.scijava.ui.swing.script.MacroFunctions;
import org.scijava.ui.swing.script.RecentFilesMenuItem;
import org.scijava.ui.swing.script.SyntaxHighlighter;
import org.scijava.ui.swing.script.TextEditorTab;
import org.scijava.ui.swing.script.TokenFunctions;
import org.scijava.ui.swing.script.commands.ChooseFontSize;
import org.scijava.ui.swing.script.commands.ChooseTabSize;
import org.scijava.ui.swing.script.commands.GitGrep;
import org.scijava.ui.swing.script.commands.KillScript;
import org.scijava.util.FileUtils;
import org.scijava.util.MiscUtils;

public class TextEditor
extends JFrame
implements ActionListener,
ChangeListener,
CloseConfirmable,
DocumentListener {
    private static final Set<String> TEMPLATE_PATHS = new HashSet<String>();
    public static final String AUTO_IMPORT_PREFS = "script.editor.AutoImport";
    public static final String WINDOW_HEIGHT = "script.editor.height";
    public static final String WINDOW_WIDTH = "script.editor.width";
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    private static AbstractTokenMakerFactory tokenMakerFactory;
    private JTabbedPane tabbed;
    private JMenuItem newFile;
    private JMenuItem open;
    private JMenuItem save;
    private JMenuItem saveas;
    private JMenuItem compileAndRun;
    private JMenuItem compile;
    private JMenuItem close;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem find;
    private JMenuItem replace;
    private JMenuItem selectAll;
    private JMenuItem kill;
    private JMenuItem gotoLine;
    private JMenuItem makeJar;
    private JMenuItem makeJarWithSource;
    private JMenuItem removeUnusedImports;
    private JMenuItem sortImports;
    private JMenuItem removeTrailingWhitespace;
    private JMenuItem findNext;
    private JMenuItem findPrevious;
    private JMenuItem openHelp;
    private JMenuItem addImport;
    private JMenuItem clearScreen;
    private JMenuItem nextError;
    private JMenuItem previousError;
    private JMenuItem openHelpWithoutFrames;
    private JMenuItem nextTab;
    private JMenuItem previousTab;
    private JMenuItem runSelection;
    private JMenuItem extractSourceJar;
    private JMenuItem toggleBookmark;
    private JMenuItem listBookmarks;
    private JMenuItem openSourceForClass;
    private JMenuItem openSourceForMenuItem;
    private JMenuItem openMacroFunctions;
    private JMenuItem decreaseFontSize;
    private JMenuItem increaseFontSize;
    private JMenuItem chooseFontSize;
    private JMenuItem chooseTabSize;
    private JMenuItem gitGrep;
    private JMenuItem openInGitweb;
    private JMenuItem replaceTabsWithSpaces;
    private JMenuItem replaceSpacesWithTabs;
    private JMenuItem toggleWhiteSpaceLabeling;
    private JMenuItem zapGremlins;
    private JMenuItem savePreferences;
    private RecentFilesMenuItem openRecent;
    private JMenu gitMenu;
    private JMenu tabsMenu;
    private JMenu fontSizeMenu;
    private JMenu tabSizeMenu;
    private JMenu toolsMenu;
    private JMenu runMenu;
    private JMenu whiteSpaceMenu;
    private int tabsMenuTabsStart;
    private Set<JMenuItem> tabsMenuItems;
    private FindAndReplaceDialog findDialog;
    private JCheckBoxMenuItem autoSave;
    private JCheckBoxMenuItem wrapLines;
    private JCheckBoxMenuItem tabsEmulated;
    private JCheckBoxMenuItem autoImport;
    private JTextArea errorScreen = new JTextArea();
    private int compileStartOffset;
    private Position compileStartPosition;
    private ErrorHandler errorHandler;
    private boolean respectAutoImports;
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private IOService ioService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ScriptHeaderService scriptHeaderService;
    @Parameter
    private UIService uiService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private AppService appService;
    private Map<ScriptLanguage, JRadioButtonMenuItem> languageMenuItems;
    private JRadioButtonMenuItem noneLanguageItem;
    protected List<AcceleratorTriplet> defaultAccelerators = new ArrayList<AcceleratorTriplet>();
    private final ArrayList<Executer> executingTasks = new ArrayList();

    public TextEditor(Context context) {
        super("Script Editor");
        context.inject((Object)this);
        this.initializeTokenMakers();
        this.loadPreferences();
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean shift = true;
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        this.newFile = this.addToMenu(file, "New", 78, ctrl);
        this.newFile.setMnemonic(78);
        this.open = this.addToMenu(file, "Open...", 79, ctrl);
        this.open.setMnemonic(79);
        this.openRecent = new RecentFilesMenuItem(this.prefService, this);
        this.openRecent.setMnemonic(82);
        file.add(this.openRecent);
        this.save = this.addToMenu(file, "Save", 83, ctrl);
        this.save.setMnemonic(83);
        this.saveas = this.addToMenu(file, "Save as...", 0, 0);
        this.saveas.setMnemonic(65);
        file.addSeparator();
        this.makeJar = this.addToMenu(file, "Export as .jar", 0, 0);
        this.makeJar.setMnemonic(69);
        this.makeJarWithSource = this.addToMenu(file, "Export as .jar (with source)", 0, 0);
        this.makeJarWithSource.setMnemonic(88);
        file.addSeparator();
        this.close = this.addToMenu(file, "Close", 87, ctrl);
        mbar.add(file);
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic(69);
        this.undo = this.addToMenu(edit, "Undo", 90, ctrl);
        this.redo = this.addToMenu(edit, "Redo", 89, ctrl);
        edit.addSeparator();
        this.selectAll = this.addToMenu(edit, "Select All", 65, ctrl);
        this.cut = this.addToMenu(edit, "Cut", 88, ctrl);
        this.copy = this.addToMenu(edit, "Copy", 67, ctrl);
        this.paste = this.addToMenu(edit, "Paste", 86, ctrl);
        edit.addSeparator();
        this.find = this.addToMenu(edit, "Find...", 70, ctrl);
        this.find.setMnemonic(70);
        this.findNext = this.addToMenu(edit, "Find Next", 114, 0);
        this.findNext.setMnemonic(78);
        this.findPrevious = this.addToMenu(edit, "Find Previous", 114, 1);
        this.findPrevious.setMnemonic(80);
        this.replace = this.addToMenu(edit, "Find and Replace...", 72, ctrl);
        this.gotoLine = this.addToMenu(edit, "Goto line...", 71, ctrl);
        this.gotoLine.setMnemonic(71);
        this.toggleBookmark = this.addToMenu(edit, "Toggle Bookmark", 66, ctrl);
        this.toggleBookmark.setMnemonic(66);
        this.listBookmarks = this.addToMenu(edit, "List Bookmarks", 0, 0);
        this.listBookmarks.setMnemonic(79);
        edit.addSeparator();
        this.decreaseFontSize = this.addToMenu(edit, "Decrease font size", 45, ctrl);
        this.decreaseFontSize.setMnemonic(68);
        this.increaseFontSize = this.addToMenu(edit, "Increase font size", 521, ctrl);
        this.increaseFontSize.setMnemonic(67);
        this.fontSizeMenu = new JMenu("Font sizes");
        this.fontSizeMenu.setMnemonic(90);
        boolean[] fontSizeShortcutUsed = new boolean[10];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final int size : new int[]{8, 10, 12, 16, 20, 28, 42}) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + size + " pt");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TextEditor.this.getEditorPane().setFontSize(size);
                    TextEditor.this.updateTabAndFontSize(false);
                }
            });
            for (char c : ("" + size).toCharArray()) {
                int digit = c - 48;
                if (fontSizeShortcutUsed[digit]) continue;
                item.setMnemonic(48 + digit);
                fontSizeShortcutUsed[digit] = true;
                break;
            }
            buttonGroup.add(item);
            this.fontSizeMenu.add(item);
        }
        this.chooseFontSize = new JRadioButtonMenuItem("Other...", false);
        this.chooseFontSize.setMnemonic(79);
        this.chooseFontSize.addActionListener(this);
        buttonGroup.add(this.chooseFontSize);
        this.fontSizeMenu.add(this.chooseFontSize);
        edit.add(this.fontSizeMenu);
        this.tabSizeMenu = new JMenu("Tab sizes");
        this.tabSizeMenu.setMnemonic(84);
        ButtonGroup bg = new ButtonGroup();
        for (final int size : new int[]{2, 4, 8}) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + size);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TextEditor.this.getEditorPane().setTabSize(size);
                    TextEditor.this.updateTabAndFontSize(false);
                }
            });
            item.setMnemonic(48 + size % 10);
            bg.add(item);
            this.tabSizeMenu.add(item);
        }
        this.chooseTabSize = new JRadioButtonMenuItem("Other...", false);
        this.chooseTabSize.setMnemonic(79);
        this.chooseTabSize.addActionListener(this);
        bg.add(this.chooseTabSize);
        this.tabSizeMenu.add(this.chooseTabSize);
        edit.add(this.tabSizeMenu);
        this.wrapLines = new JCheckBoxMenuItem("Wrap lines");
        this.wrapLines.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextEditor.this.getEditorPane().setLineWrap(TextEditor.this.wrapLines.getState());
            }
        });
        edit.add(this.wrapLines);
        this.tabsEmulated = new JCheckBoxMenuItem("Tab key inserts spaces");
        this.tabsEmulated.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextEditor.this.getEditorPane().setTabsEmulated(TextEditor.this.tabsEmulated.getState());
            }
        });
        edit.add(this.tabsEmulated);
        this.savePreferences = this.addToMenu(edit, "Save Preferences", 0, 0);
        edit.addSeparator();
        this.clearScreen = this.addToMenu(edit, "Clear output panel", 0, 0);
        this.clearScreen.setMnemonic(76);
        this.zapGremlins = this.addToMenu(edit, "Zap Gremlins", 0, 0);
        edit.addSeparator();
        this.addImport = this.addToMenu(edit, "Add import...", 0, 0);
        this.addImport.setMnemonic(73);
        this.removeUnusedImports = this.addToMenu(edit, "Remove unused imports", 0, 0);
        this.removeUnusedImports.setMnemonic(85);
        this.sortImports = this.addToMenu(edit, "Sort imports", 0, 0);
        this.sortImports.setMnemonic(83);
        this.respectAutoImports = this.prefService.getBoolean(AUTO_IMPORT_PREFS, false);
        this.autoImport = new JCheckBoxMenuItem("Auto-import (deprecated)", this.respectAutoImports);
        this.autoImport.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextEditor.this.respectAutoImports = e.getStateChange() == 1;
                TextEditor.this.prefService.put(TextEditor.AUTO_IMPORT_PREFS, TextEditor.this.respectAutoImports);
            }
        });
        edit.add(this.autoImport);
        mbar.add(edit);
        this.whiteSpaceMenu = new JMenu("Whitespace");
        this.whiteSpaceMenu.setMnemonic(87);
        this.removeTrailingWhitespace = this.addToMenu(this.whiteSpaceMenu, "Remove trailing whitespace", 0, 0);
        this.removeTrailingWhitespace.setMnemonic(87);
        this.replaceTabsWithSpaces = this.addToMenu(this.whiteSpaceMenu, "Replace tabs with spaces", 0, 0);
        this.replaceTabsWithSpaces.setMnemonic(83);
        this.replaceSpacesWithTabs = this.addToMenu(this.whiteSpaceMenu, "Replace spaces with tabs", 0, 0);
        this.replaceSpacesWithTabs.setMnemonic(84);
        this.toggleWhiteSpaceLabeling = new JRadioButtonMenuItem("Label whitespace");
        this.toggleWhiteSpaceLabeling.setMnemonic(76);
        this.toggleWhiteSpaceLabeling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditor.this.getTextArea().setWhitespaceVisible(TextEditor.this.toggleWhiteSpaceLabeling.isSelected());
            }
        });
        this.whiteSpaceMenu.add(this.toggleWhiteSpaceLabeling);
        edit.add(this.whiteSpaceMenu);
        this.languageMenuItems = new LinkedHashMap<ScriptLanguage, JRadioButtonMenuItem>();
        HashSet<Integer> usedShortcuts = new HashSet<Integer>();
        JMenu languages = new JMenu("Language");
        languages.setMnemonic(76);
        ButtonGroup group = new ButtonGroup();
        ArrayList list = new ArrayList(this.scriptService.getLanguages());
        Collections.sort(list, new Comparator<ScriptLanguage>(){

            @Override
            public int compare(ScriptLanguage l1, ScriptLanguage l2) {
                String name1 = l1.getLanguageName();
                String name2 = l2.getLanguageName();
                return MiscUtils.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
            }
        });
        list.add(null);
        HashMap<String, ScriptLanguage> languageMap = new HashMap<String, ScriptLanguage>();
        for (final ScriptLanguage language : list) {
            String name = language == null ? "None" : language.getLanguageName();
            languageMap.put(name, language);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
            if (language == null) {
                this.noneLanguageItem = item;
            } else {
                this.languageMenuItems.put(language, item);
            }
            int shortcut = -1;
            for (char ch : name.toCharArray()) {
                int keyCode = KeyStroke.getKeyStroke((int)ch, 0).getKeyCode();
                if (usedShortcuts.contains(keyCode)) continue;
                shortcut = keyCode;
                usedShortcuts.add(shortcut);
                break;
            }
            if (shortcut > 0) {
                item.setMnemonic(shortcut);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextEditor.this.setLanguage(language, true);
                }
            });
            group.add(item);
            languages.add(item);
        }
        this.noneLanguageItem.setSelected(true);
        mbar.add(languages);
        JMenu templates = new JMenu("Templates");
        templates.setMnemonic(84);
        this.addTemplates(templates);
        mbar.add(templates);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        this.compileAndRun = this.addToMenu(this.runMenu, "Compile and Run", 82, ctrl);
        this.compileAndRun.setMnemonic(82);
        this.runSelection = this.addToMenu(this.runMenu, "Run selected code", 82, ctrl | 1);
        this.runSelection.setMnemonic(83);
        this.compile = this.addToMenu(this.runMenu, "Compile", 67, ctrl | 1);
        this.compile.setMnemonic(67);
        this.autoSave = new JCheckBoxMenuItem("Auto-save before compiling");
        this.runMenu.add(this.autoSave);
        this.runMenu.addSeparator();
        this.nextError = this.addToMenu(this.runMenu, "Next Error", 115, 0);
        this.nextError.setMnemonic(78);
        this.previousError = this.addToMenu(this.runMenu, "Previous Error", 115, 1);
        this.previousError.setMnemonic(80);
        this.runMenu.addSeparator();
        this.kill = this.addToMenu(this.runMenu, "Kill running script...", 0, 0);
        this.kill.setMnemonic(75);
        this.kill.setEnabled(false);
        mbar.add(this.runMenu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(79);
        this.openHelpWithoutFrames = this.addToMenu(this.toolsMenu, "Open Help for Class...", 0, 0);
        this.openHelpWithoutFrames.setMnemonic(79);
        this.openHelp = this.addToMenu(this.toolsMenu, "Open Help for Class (with frames)...", 0, 0);
        this.openHelp.setMnemonic(80);
        this.openMacroFunctions = this.addToMenu(this.toolsMenu, "Open Help on Macro Functions...", 0, 0);
        this.openMacroFunctions.setMnemonic(72);
        this.extractSourceJar = this.addToMenu(this.toolsMenu, "Extract source .jar...", 0, 0);
        this.extractSourceJar.setMnemonic(69);
        this.openSourceForClass = this.addToMenu(this.toolsMenu, "Open .java file for class...", 0, 0);
        this.openSourceForClass.setMnemonic(74);
        this.openSourceForMenuItem = this.addToMenu(this.toolsMenu, "Open .java file for menu item...", 0, 0);
        this.openSourceForMenuItem.setMnemonic(77);
        mbar.add(this.toolsMenu);
        this.gitMenu = new JMenu("Git");
        this.gitMenu.setMnemonic(71);
        this.gitGrep = this.addToMenu(this.gitMenu, "Grep...", 0, 0);
        this.gitGrep.setMnemonic(71);
        this.openInGitweb = this.addToMenu(this.gitMenu, "Open in gitweb", 0, 0);
        this.openInGitweb.setMnemonic(87);
        mbar.add(this.gitMenu);
        this.tabsMenu = new JMenu("Tabs");
        this.tabsMenu.setMnemonic(65);
        this.nextTab = this.addToMenu(this.tabsMenu, "Next Tab", 34, ctrl);
        this.nextTab.setMnemonic(78);
        this.previousTab = this.addToMenu(this.tabsMenu, "Previous Tab", 33, ctrl);
        this.previousTab.setMnemonic(80);
        this.tabsMenu.addSeparator();
        this.tabsMenuTabsStart = this.tabsMenu.getItemCount();
        this.tabsMenuItems = new HashSet<JMenuItem>();
        mbar.add(this.tabsMenu);
        this.tabbed = new JTabbedPane();
        this.tabbed.addChangeListener(this);
        this.open(null);
        this.tabbed.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.tabbed);
        this.addAccelerator(this.compileAndRun, 122, 0, true);
        this.addAccelerator(this.compileAndRun, 116, 0, true);
        this.addAccelerator(this.nextTab, 34, ctrl, true);
        this.addAccelerator(this.previousTab, 33, ctrl, true);
        this.addAccelerator(this.increaseFontSize, 61, ctrl | 1, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!TextEditor.this.confirmClose()) {
                    return;
                }
                TextEditor.this.dispose();
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                TextEditor.this.checkForOutsideChanges();
            }
        });
        Font font = new Font("Courier", 0, 12);
        this.errorScreen.setFont(font);
        this.errorScreen.setEditable(false);
        this.errorScreen.setLineWrap(true);
        this.setDefaultCloseOperation(0);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.pack();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TextEditor.this.pack();
                    }
                });
            }
        }
        catch (Exception name) {
            // empty catch block
        }
        this.findDialog = new FindAndReplaceDialog(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TextEditor.this.saveWindowSizeToPrefs();
            }
        });
        this.setLocationRelativeTo(null);
        this.open(null);
        EditorPane editorPane = this.getEditorPane();
        editorPane.requestFocus();
    }

    public LogService log() {
        return this.log;
    }

    public PlatformService getPlatformService() {
        return this.platformService;
    }

    public JTextArea getErrorScreen() {
        return this.errorScreen;
    }

    public void setErrorScreen(JTextArea errorScreen) {
        this.errorScreen = errorScreen;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private synchronized void initializeTokenMakers() {
        if (tokenMakerFactory != null) {
            return;
        }
        tokenMakerFactory = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        for (PluginInfo info : this.pluginService.getPluginsOfType(SyntaxHighlighter.class)) {
            try {
                tokenMakerFactory.putMapping("text/" + info.getName(), info.getClassName());
            }
            catch (Throwable t) {
                this.log.warn((Object)("Could not register " + info.getName()), t);
            }
        }
    }

    public void checkForOutsideChanges() {
        EditorPane editorPane = this.getEditorPane();
        if (editorPane.wasChangedOutside()) {
            this.reload("The file " + editorPane.getFile().getName() + " was changed outside of the editor");
        }
    }

    public static void addTemplatePath(String path) {
        TEMPLATE_PATHS.add(path);
    }

    @EventHandler
    private void onEvent(ContextDisposingEvent e) {
        if (this.isDisplayable()) {
            this.dispose();
        }
    }

    public void loadPreferences() {
        Dimension dim = this.getSize();
        if (0 == dim.width) {
            dim.width = 800;
        }
        if (0 == dim.height) {
            dim.height = 600;
        }
        this.setPreferredSize(new Dimension(this.prefService.getInt(WINDOW_WIDTH, dim.width), this.prefService.getInt(WINDOW_HEIGHT, dim.height)));
    }

    public void saveWindowSizeToPrefs() {
        Dimension dim = this.getSize();
        this.prefService.put(WINDOW_HEIGHT, dim.height);
        this.prefService.put(WINDOW_WIDTH, dim.width);
    }

    public final RSyntaxTextArea getTextArea() {
        return this.getEditorPane();
    }

    public TextEditorTab getTab() {
        int index = this.tabbed.getSelectedIndex();
        if (index < 0) {
            if (this.tabbed.getTabCount() == 0) {
                this.createNewDocument();
            }
            this.tabbed.setSelectedIndex(0);
            index = 0;
        }
        return (TextEditorTab)this.tabbed.getComponentAt(index);
    }

    public TextEditorTab getTab(int index) {
        return (TextEditorTab)this.tabbed.getComponentAt(index);
    }

    public EditorPane getEditorPane() {
        return this.getTab().editorPane;
    }

    public ScriptLanguage getCurrentLanguage() {
        return this.getEditorPane().getCurrentLanguage();
    }

    public JMenuItem addToMenu(JMenu menu, String menuEntry, int key, int modifiers) {
        JMenuItem item = new JMenuItem(menuEntry);
        menu.add(item);
        if (key != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(key, modifiers));
        }
        item.addActionListener(this);
        return item;
    }

    public void addAccelerator(JMenuItem component, int key, int modifiers) {
        this.addAccelerator(component, key, modifiers, false);
    }

    public void addAccelerator(JMenuItem component, int key, int modifiers, boolean record) {
        RSyntaxTextArea textArea;
        if (record) {
            AcceleratorTriplet triplet = new AcceleratorTriplet();
            triplet.component = component;
            triplet.key = key;
            triplet.modifiers = modifiers;
            this.defaultAccelerators.add(triplet);
        }
        if ((textArea = this.getTextArea()) != null) {
            this.addAccelerator(textArea, component, key, modifiers);
        }
    }

    public void addAccelerator(RSyntaxTextArea textArea, final JMenuItem component, int key, int modifiers) {
        textArea.getInputMap().put(KeyStroke.getKeyStroke(key, modifiers), component);
        textArea.getActionMap().put(component, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!component.isEnabled()) {
                    return;
                }
                ActionEvent event = new ActionEvent(component, 0, "Accelerator");
                TextEditor.this.actionPerformed(event);
            }
        });
    }

    public void addDefaultAccelerators(RSyntaxTextArea textArea) {
        for (AcceleratorTriplet triplet : this.defaultAccelerators) {
            this.addAccelerator(textArea, triplet.component, triplet.key, triplet.modifiers);
        }
    }

    private JMenu getMenu(JMenu root, String menuItemPath, boolean createIfNecessary) {
        int slash = menuItemPath.indexOf(47);
        if (slash < 0) {
            return root;
        }
        String menuLabel = menuItemPath.substring(0, slash);
        String rest = menuItemPath.substring(slash + 1);
        for (int i = 0; i < root.getItemCount(); ++i) {
            JMenuItem item = root.getItem(i);
            if (!(item instanceof JMenu) || !menuLabel.equals(item.getText())) continue;
            return this.getMenu((JMenu)item, rest, createIfNecessary);
        }
        if (!createIfNecessary) {
            return null;
        }
        JMenu subMenu = new JMenu(menuLabel);
        root.add(subMenu);
        return this.getMenu(subMenu, rest, createIfNecessary);
    }

    private void addTemplates(JMenu templatesMenu) {
        File baseDir = this.appService.getApp().getBaseDirectory();
        for (String templatePath : TEMPLATE_PATHS) {
            for (final Map.Entry entry : new TreeMap(FileUtils.findResources(null, (String)templatePath, (File)baseDir)).entrySet()) {
                String key = (String)entry.getKey();
                String ext = FileUtils.getExtension((String)key);
                ScriptLanguage lang = ext.isEmpty() ? null : this.scriptService.getLanguageByExtension(ext);
                String langName = lang == null ? null : lang.getLanguageName();
                String langSuffix = lang == null ? null : " (" + langName + ")";
                String path = this.adjustPath(key, langName);
                int labelIndex = path.lastIndexOf(47) + 1;
                String label = ext.isEmpty() ? path.substring(labelIndex) : path.substring(labelIndex, path.length() - ext.length() - 1);
                ActionListener menuListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TextEditor.this.loadTemplate((URL)entry.getValue());
                    }
                };
                if (langName != null) {
                    String langPath = "[by language]/" + langName + "/" + path;
                    JMenu langMenu = this.getMenu(templatesMenu, langPath, true);
                    JMenuItem langItem = new JMenuItem(label);
                    langMenu.add(langItem);
                    langItem.addActionListener(menuListener);
                }
                JMenu menu = this.getMenu(templatesMenu, path, true);
                JMenuItem item = new JMenuItem(label + langSuffix);
                menu.add(item);
                item.addActionListener(menuListener);
            }
        }
    }

    public void loadTemplate(String url) {
        try {
            this.loadTemplate(new URL(url));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            this.error("The template '" + url + "' was not found.");
        }
    }

    public void loadTemplate(URL url) {
        String path = url.getPath();
        String ext = FileUtils.getExtension((String)path);
        ScriptLanguage language = ext.isEmpty() ? null : this.scriptService.getLanguageByExtension(ext);
        this.loadTemplate(url, language);
    }

    public void loadTemplate(URL url, ScriptLanguage language) {
        this.createNewDocument();
        try {
            InputStream in = url.openStream();
            this.getTextArea().read((Reader)new BufferedReader(new InputStreamReader(in)), null);
            if (language != null) {
                this.setLanguage(language);
            }
            String path = url.getPath();
            this.setEditorPaneFileName(path.substring(path.lastIndexOf(47) + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("The template '" + url + "' was not found.");
        }
    }

    public void createNewDocument() {
        this.open(null);
    }

    public void createNewDocument(String title, String text) {
        this.open(null);
        EditorPane editorPane = this.getEditorPane();
        editorPane.setText(text);
        this.setEditorPaneFileName(title);
        editorPane.setLanguageByFileName(title);
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
    }

    public void createNewFromTemplate(File file, File templateFile) {
        this.open(file.exists() ? file : templateFile);
        if (!file.exists()) {
            EditorPane editorPane = this.getEditorPane();
            try {
                editorPane.open(file);
            }
            catch (IOException e) {
                this.handleException(e);
            }
            editorPane.setLanguageByFileName(file.getName());
            this.updateLanguageMenu(editorPane.getCurrentLanguage());
        }
    }

    public boolean fileChanged() {
        return this.getEditorPane().fileChanged();
    }

    public boolean handleUnsavedChanges() {
        return this.handleUnsavedChanges(false);
    }

    public boolean handleUnsavedChanges(boolean beforeCompiling) {
        if (!this.fileChanged()) {
            return true;
        }
        if (beforeCompiling && this.autoSave.getState()) {
            this.save();
            return true;
        }
        switch (JOptionPane.showConfirmDialog(this, "Do you want to save changes?")) {
            case 1: {
                return !beforeCompiling;
            }
            case 0: {
                if (!this.save()) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block108: {
            Object source = ae.getSource();
            if (source == this.newFile) {
                this.createNewDocument();
            } else {
                if (source == this.open) {
                    EditorPane editorPane = this.getEditorPane();
                    File defaultDir = editorPane.getFile() != null ? editorPane.getFile().getParentFile() : this.appService.getApp().getBaseDirectory();
                    final File file = this.openWithDialog(defaultDir);
                    if (file != null) {
                        new Thread(){

                            @Override
                            public void run() {
                                TextEditor.this.open(file);
                            }
                        }.start();
                    }
                    return;
                }
                if (source == this.save) {
                    this.save();
                } else if (source == this.saveas) {
                    this.saveAs();
                } else if (source == this.makeJar) {
                    this.makeJar(false);
                } else if (source == this.makeJarWithSource) {
                    this.makeJar(true);
                } else if (source == this.compileAndRun) {
                    this.runText();
                } else if (source == this.compile) {
                    this.compile();
                } else if (source == this.runSelection) {
                    this.runText(true);
                } else if (source == this.nextError) {
                    new Thread(){

                        @Override
                        public void run() {
                            TextEditor.this.nextError(true);
                        }
                    }.start();
                } else if (source == this.previousError) {
                    new Thread(){

                        @Override
                        public void run() {
                            TextEditor.this.nextError(false);
                        }
                    }.start();
                } else if (source == this.kill) {
                    this.chooseTaskToKill();
                } else if (source == this.close) {
                    if (this.tabbed.getTabCount() < 2) {
                        this.processWindowEvent(new WindowEvent(this, 201));
                    } else {
                        if (!this.handleUnsavedChanges()) {
                            return;
                        }
                        int index = this.tabbed.getSelectedIndex();
                        this.removeTab(index);
                        if (index > 0) {
                            --index;
                        }
                        this.switchTo(index);
                    }
                } else if (source == this.cut) {
                    this.getTextArea().cut();
                } else if (source == this.copy) {
                    this.getTextArea().copy();
                } else if (source == this.paste) {
                    this.getTextArea().paste();
                } else if (source == this.undo) {
                    this.getTextArea().undoLastAction();
                } else if (source == this.redo) {
                    this.getTextArea().redoLastAction();
                } else if (source == this.find) {
                    this.findOrReplace(false);
                } else if (source == this.findNext) {
                    this.findDialog.searchOrReplace(false);
                } else if (source == this.findPrevious) {
                    this.findDialog.searchOrReplace(false, false);
                } else if (source == this.replace) {
                    this.findOrReplace(true);
                } else if (source == this.gotoLine) {
                    this.gotoLine();
                } else if (source == this.toggleBookmark) {
                    this.toggleBookmark();
                } else if (source == this.listBookmarks) {
                    this.listBookmarks();
                } else if (source == this.selectAll) {
                    this.getTextArea().setCaretPosition(0);
                    this.getTextArea().moveCaretPosition(this.getTextArea().getDocument().getLength());
                } else if (source == this.chooseFontSize) {
                    this.commandService.run(ChooseFontSize.class, true, new Object[]{"editor", this});
                } else if (source == this.chooseTabSize) {
                    this.commandService.run(ChooseTabSize.class, true, new Object[]{"editor", this});
                } else if (source == this.addImport) {
                    this.addImport(this.getSelectedClassNameOrAsk());
                } else if (source == this.removeUnusedImports) {
                    new TokenFunctions(this.getTextArea()).removeUnusedImports();
                } else if (source == this.sortImports) {
                    new TokenFunctions(this.getTextArea()).sortImports();
                } else if (source == this.removeTrailingWhitespace) {
                    new TokenFunctions(this.getTextArea()).removeTrailingWhitespace();
                } else if (source == this.replaceTabsWithSpaces) {
                    this.getTextArea().convertTabsToSpaces();
                } else if (source == this.replaceSpacesWithTabs) {
                    this.getTextArea().convertSpacesToTabs();
                } else if (source == this.clearScreen) {
                    this.getTab().getScreen().setText("");
                } else if (source == this.zapGremlins) {
                    this.zapGremlins();
                } else if (source == this.savePreferences) {
                    this.getEditorPane().savePreferences();
                } else if (source == this.openHelp) {
                    this.openHelp(null);
                } else if (source == this.openHelpWithoutFrames) {
                    this.openHelp(null, false);
                } else if (source == this.openMacroFunctions) {
                    try {
                        new MacroFunctions(this).openHelp(this.getTextArea().getSelectedText());
                    }
                    catch (IOException e) {
                        this.handleException(e);
                    }
                } else if (source == this.extractSourceJar) {
                    this.extractSourceJar();
                } else if (source == this.openSourceForClass) {
                    String className = this.getSelectedClassNameOrAsk();
                    if (className != null) {
                        try {
                            String path = new FileFunctions(this).getSourcePath(className);
                            if (path != null) {
                                this.open(new File(path));
                                break block108;
                            }
                            String url = new FileFunctions(this).getSourceURL(className);
                            try {
                                this.platformService.open(new URL(url));
                            }
                            catch (Throwable e) {
                                this.handleException(e);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            this.error("Could not open source for class " + className);
                        }
                    }
                } else if (source == this.gitGrep) {
                    String searchTerm = this.getTextArea().getSelectedText();
                    File searchRoot = this.getEditorPane().getFile();
                    if (searchRoot == null) {
                        this.error("File was not yet saved; no location known!");
                        return;
                    }
                    searchRoot = searchRoot.getParentFile();
                    this.commandService.run(GitGrep.class, true, new Object[]{"editor", this, "searchTerm", searchTerm, "searchRoot", searchRoot});
                } else if (source == this.openInGitweb) {
                    EditorPane editorPane = this.getEditorPane();
                    new FileFunctions(this).openInGitweb(editorPane.getFile(), editorPane.getGitDirectory(), editorPane.getCaretLineNumber() + 1);
                } else if (source == this.increaseFontSize || source == this.decreaseFontSize) {
                    this.getEditorPane().increaseFontSize((float)(source == this.increaseFontSize ? 1.2 : 0.8333333333333334));
                    this.updateTabAndFontSize(false);
                } else if (source == this.nextTab) {
                    this.switchTabRelative(1);
                } else if (source == this.previousTab) {
                    this.switchTabRelative(-1);
                } else if (this.handleTabsMenu(source)) {
                    return;
                }
            }
        }
    }

    protected boolean handleTabsMenu(Object source) {
        if (!(source instanceof JMenuItem)) {
            return false;
        }
        JMenuItem item = (JMenuItem)source;
        if (!this.tabsMenuItems.contains(item)) {
            return false;
        }
        for (int i = this.tabsMenuTabsStart; i < this.tabsMenu.getItemCount(); ++i) {
            if (this.tabsMenu.getItem(i) != item) continue;
            this.switchTo(i - this.tabsMenuTabsStart);
            return true;
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbed.getSelectedIndex();
        if (index < 0) {
            this.setTitle("");
            return;
        }
        EditorPane editorPane = this.getEditorPane(index);
        editorPane.requestFocus();
        this.checkForOutsideChanges();
        this.toggleWhiteSpaceLabeling.setSelected(editorPane.isWhitespaceVisible());
        editorPane.setLanguageByFileName(editorPane.getFileName());
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
        this.setTitle();
    }

    public EditorPane getEditorPane(int index) {
        return this.getTab((int)index).editorPane;
    }

    public void findOrReplace(boolean doReplace) {
        this.findDialog.setLocationRelativeTo(this);
        String selection = this.getTextArea().getSelectedText();
        if (selection != null) {
            this.findDialog.setSearchPattern(selection);
        }
        this.findDialog.show(doReplace);
    }

    public void gotoLine() {
        String line = JOptionPane.showInputDialog(this, "Line:", "Goto line...", 3);
        if (line == null) {
            return;
        }
        try {
            this.gotoLine(Integer.parseInt(line));
        }
        catch (BadLocationException e) {
            this.error("Line number out of range: " + line);
        }
        catch (NumberFormatException e) {
            this.error("Invalid line number: " + line);
        }
    }

    public void gotoLine(int line) throws BadLocationException {
        this.getTextArea().setCaretPosition(this.getTextArea().getLineStartOffset(line - 1));
    }

    public void toggleBookmark() {
        this.getEditorPane().toggleBookmark();
    }

    public void listBookmarks() {
        Vector<Bookmark> bookmarks = new Vector<Bookmark>();
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            TextEditorTab tab = (TextEditorTab)this.tabbed.getComponentAt(i);
            tab.editorPane.getBookmarks(tab, bookmarks);
        }
        BookmarkDialog dialog = new BookmarkDialog((Frame)this, bookmarks);
        dialog.setVisible(true);
    }

    public boolean reload() {
        return this.reload("Reload the file?");
    }

    public boolean reload(String message) {
        EditorPane editorPane = this.getEditorPane();
        File file = editorPane.getFile();
        if (file == null || !file.exists()) {
            return true;
        }
        boolean modified = editorPane.fileChanged();
        Object[] options = new String[]{"Reload", "Do not reload"};
        if (modified) {
            options[0] = "Reload (discarding changes)";
        }
        switch (JOptionPane.showOptionDialog(this, message, "Reload", -1, 2, null, options, options[0])) {
            case 0: {
                try {
                    editorPane.open(file);
                    return true;
                }
                catch (IOException e) {
                    this.error("Could not reload " + file.getPath());
                    this.updateLanguageMenu(editorPane.getCurrentLanguage());
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBinary(File file) {
        if (file == null) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int count;
            int left = 8000;
            byte[] buffer = new byte[left];
            if (left > 0 && (count = in.read(buffer, 0, left)) >= 0) {
                int i = 0;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public TextEditorTab newTab(String content, String language) {
        String lang = language;
        TextEditorTab tab = this.open(null);
        if (null != lang && lang.length() > 0) {
            if ('.' != (lang = lang.trim().toLowerCase()).charAt(0)) {
                lang = "." + language;
            }
            tab.editorPane.setLanguage(this.scriptService.getLanguageByName(language));
        }
        if (null != content) {
            tab.editorPane.setText(content);
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextEditorTab open(File file) {
        if (TextEditor.isBinary(file)) {
            throw new RuntimeException("TODO: open image using IJ2");
        }
        try {
            boolean wasNew;
            TextEditorTab tab = this.tabbed.getTabCount() == 0 ? null : this.getTab();
            boolean bl = wasNew = tab != null && tab.editorPane.isNew();
            if (!wasNew) {
                tab = new TextEditorTab(this);
                this.context.inject((Object)tab.editorPane);
                tab.editorPane.loadPreferences();
                tab.editorPane.getDocument().addDocumentListener(this);
                this.addDefaultAccelerators(tab.editorPane);
            }
            EditorPane editorPane = tab.editorPane;
            synchronized (editorPane) {
                tab.editorPane.open(file);
                if (wasNew) {
                    int index = this.tabbed.getSelectedIndex() + this.tabsMenuTabsStart;
                    this.tabsMenu.getItem(index).setText(tab.editorPane.getFileName());
                } else {
                    this.tabbed.addTab("", tab);
                    this.switchTo(this.tabbed.getTabCount() - 1);
                    this.tabsMenuItems.add(this.addToMenu(this.tabsMenu, tab.editorPane.getFileName(), 0, 0));
                }
                this.setEditorPaneFileName(tab.editorPane.getFile());
                try {
                    this.updateTabAndFontSize(true);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (file != null) {
                this.openRecent.add(file.getAbsolutePath());
            }
            this.updateLanguageMenu(tab.editorPane.getCurrentLanguage());
            return tab;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.error("The file '" + file + "' was not found.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("There was an error while opening '" + file + "': " + e);
        }
        return null;
    }

    public boolean saveAs() {
        File fileToSave;
        EditorPane editorPane = this.getEditorPane();
        File file = editorPane.getFile();
        if (file == null) {
            File ijDir = this.appService.getApp().getBaseDirectory();
            file = new File(ijDir, editorPane.getFileName());
        }
        if ((fileToSave = this.uiService.chooseFile(file, "save")) == null) {
            return false;
        }
        return this.saveAs(fileToSave.getAbsolutePath(), true);
    }

    public void saveAs(String path) {
        this.saveAs(path, true);
    }

    public boolean saveAs(String path, boolean askBeforeReplacing) {
        File file = new File(path);
        if (file.exists() && askBeforeReplacing && JOptionPane.showConfirmDialog(this, "Do you want to replace " + path + "?", "Replace " + path + "?", 0) != 0) {
            return false;
        }
        if (!this.write(file)) {
            return false;
        }
        this.setEditorPaneFileName(file);
        this.openRecent.add(path);
        return true;
    }

    public boolean save() {
        File file = this.getEditorPane().getFile();
        if (file == null) {
            return this.saveAs();
        }
        if (!this.write(file)) {
            return false;
        }
        this.setTitle();
        return true;
    }

    public boolean write(File file) {
        try {
            this.getEditorPane().write(file);
            return true;
        }
        catch (IOException e) {
            this.error("Could not save " + file.getName());
            e.printStackTrace();
            return false;
        }
    }

    public boolean makeJar(boolean includeSources) {
        File file = this.getEditorPane().getFile();
        if ((file == null || this.isCompiled()) && !this.handleUnsavedChanges(true)) {
            return false;
        }
        String name = this.getEditorPane().getFileName();
        String ext = FileUtils.getExtension((String)name);
        if (!"".equals(ext)) {
            name = name.substring(0, name.length() - ext.length());
        }
        if (name.indexOf(95) < 0) {
            name = name + "_";
        }
        name = name + ".jar";
        File selectedFile = this.uiService.chooseFile(file, "save");
        if (selectedFile == null) {
            return false;
        }
        if (selectedFile.exists() && JOptionPane.showConfirmDialog(this, "Do you want to replace " + selectedFile + "?", "Replace " + selectedFile + "?", 0) != 0) {
            return false;
        }
        try {
            this.makeJar(selectedFile, includeSources);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error("Could not write " + selectedFile + ": " + e.getMessage());
            return false;
        }
    }

    public void makeJar(final File file, final boolean includeSources) throws IOException {
        if (!this.handleUnsavedChanges(true)) {
            return;
        }
        ScriptEngine interpreter = this.getCurrentLanguage().getScriptEngine();
        if (interpreter instanceof JavaEngine) {
            final JavaEngine java = (JavaEngine)interpreter;
            final JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
            this.markCompileStart();
            this.getTab().showErrors();
            new Thread(){

                @Override
                public void run() {
                    java.makeJar(TextEditor.this.getEditorPane().getFile(), includeSources, file, (Writer)errors);
                    TextEditor.this.errorScreen.insert("Compilation finished.\n", TextEditor.this.errorScreen.getDocument().getLength());
                    TextEditor.this.markCompileEnd();
                }
            }.start();
        }
    }

    static void getClasses(File directory, List<String> paths, List<String> names) {
        TextEditor.getClasses(directory, paths, names, "");
    }

    static void getClasses(File directory, List<String> paths, List<String> names, String inPrefix) {
        String prefix = inPrefix;
        if (!prefix.equals("")) {
            prefix = prefix + "/";
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                TextEditor.getClasses(file, paths, names, prefix + file.getName());
                continue;
            }
            paths.add(file.getAbsolutePath());
            names.add(prefix + file.getName());
        }
    }

    static void writeJarEntry(JarOutputStream out, String name, byte[] buf) throws IOException {
        try {
            JarEntry entry = new JarEntry(name);
            out.putNextEntry(entry);
            out.write(buf, 0, buf.length);
            out.closeEntry();
        }
        catch (ZipException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    static byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            ((InputStream)in).read(buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }

    static void deleteRecursively(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                TextEditor.deleteRecursively(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    void setLanguage(ScriptLanguage language) {
        this.setLanguage(language, false);
    }

    void setLanguage(ScriptLanguage language, boolean addHeader) {
        this.getEditorPane().setLanguage(language, addHeader);
        this.setTitle();
        this.updateLanguageMenu(language);
        this.updateTabAndFontSize(true);
    }

    void updateLanguageMenu(ScriptLanguage language) {
        JMenuItem item = this.languageMenuItems.get(language);
        if (item == null) {
            item = this.noneLanguageItem;
        }
        if (!item.isSelected()) {
            item.setSelected(true);
        }
        boolean isRunnable = item != this.noneLanguageItem;
        boolean isCompileable = language != null && language.isCompiledLanguage();
        this.runMenu.setVisible(isRunnable);
        this.compileAndRun.setText(isCompileable ? "Compile and Run" : "Run");
        this.compileAndRun.setEnabled(isRunnable);
        this.runSelection.setVisible(isRunnable && !isCompileable);
        this.compile.setVisible(isCompileable);
        this.autoSave.setVisible(isCompileable);
        this.makeJar.setVisible(isCompileable);
        this.makeJarWithSource.setVisible(isCompileable);
        boolean isJava = language != null && language.getLanguageName().equals("Java");
        this.addImport.setVisible(isJava);
        this.removeUnusedImports.setVisible(isJava);
        this.sortImports.setVisible(isJava);
        this.openSourceForMenuItem.setVisible(isJava);
        boolean isMacro = language != null && language.getLanguageName().equals("ImageJ Macro");
        this.openMacroFunctions.setVisible(isMacro);
        this.openSourceForClass.setVisible(!isMacro);
        this.openHelp.setVisible(!isMacro && isRunnable);
        this.openHelpWithoutFrames.setVisible(!isMacro && isRunnable);
        this.nextError.setVisible(!isMacro && isRunnable);
        this.previousError.setVisible(!isMacro && isRunnable);
        boolean isInGit = this.getEditorPane().getGitDirectory() != null;
        this.gitMenu.setVisible(isInGit);
        this.updateTabAndFontSize(false);
    }

    public void updateTabAndFontSize(boolean setByLanguage) {
        EditorPane pane = this.getEditorPane();
        if (pane.getCurrentLanguage() == null) {
            return;
        }
        if (setByLanguage) {
            if (pane.getCurrentLanguage().getLanguageName().equals("Python")) {
                pane.setTabSize(4);
            } else {
                pane.resetTabSize();
            }
        }
        int tabSize = pane.getTabSize();
        boolean defaultSize = false;
        for (int i = 0; i < this.tabSizeMenu.getItemCount(); ++i) {
            JMenuItem item = this.tabSizeMenu.getItem(i);
            if (item == this.chooseTabSize) {
                item.setSelected(!defaultSize);
                item.setText("Other" + (defaultSize ? "" : " (" + tabSize + ")") + "...");
                continue;
            }
            if (tabSize != Integer.parseInt(item.getText())) continue;
            item.setSelected(true);
            defaultSize = true;
        }
        int fontSize = (int)pane.getFontSize();
        defaultSize = false;
        for (int i = 0; i < this.fontSizeMenu.getItemCount(); ++i) {
            JMenuItem item = this.fontSizeMenu.getItem(i);
            if (item == this.chooseFontSize) {
                item.setSelected(!defaultSize);
                item.setText("Other" + (defaultSize ? "" : " (" + fontSize + ")") + "...");
                continue;
            }
            String label = item.getText();
            if (label.endsWith(" pt")) {
                label = label.substring(0, label.length() - 3);
            }
            if (fontSize != Integer.parseInt(label)) continue;
            item.setSelected(true);
            defaultSize = true;
        }
        this.wrapLines.setState(pane.getLineWrap());
        this.tabsEmulated.setState(pane.getTabsEmulated());
    }

    public void setEditorPaneFileName(String baseName) {
        this.getEditorPane().setFileName(baseName);
    }

    public void setEditorPaneFileName(File file) {
        EditorPane editorPane = this.getEditorPane();
        editorPane.setFileName(file);
        this.updateLanguageMenu(editorPane.getCurrentLanguage());
        this.updateGitDirectory();
    }

    void setTitle() {
        EditorPane editorPane = this.getEditorPane();
        boolean fileChanged = editorPane.fileChanged();
        String fileName = editorPane.getFileName();
        final String title = (fileChanged ? "*" : "") + fileName + (this.executingTasks.isEmpty() ? "" : " (Running)");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextEditor.this.setTitle(title);
                for (int i = 0; i < TextEditor.this.tabbed.getTabCount(); ++i) {
                    TextEditor.this.tabbed.setTitleAt(i, ((TextEditorTab)TextEditor.this.tabbed.getComponentAt(i)).getTitle());
                }
            }
        });
    }

    @Override
    public synchronized void setTitle(String title) {
        JMenuItem item;
        super.setTitle(title);
        int index = this.tabsMenuTabsStart + this.tabbed.getSelectedIndex();
        if (index < this.tabsMenu.getItemCount() && (item = this.tabsMenu.getItem(index)) != null) {
            item.setText(title);
        }
    }

    public List<Executer> getExecutingTasks() {
        return this.executingTasks;
    }

    public void kill(Executer executer) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            TextEditorTab tab = (TextEditorTab)this.tabbed.getComponentAt(i);
            if (executer != tab.getExecuter()) continue;
            tab.kill();
            break;
        }
    }

    public void chooseTaskToKill() {
        if (this.executingTasks.size() == 0) {
            this.error("\nNo running scripts\n");
            return;
        }
        this.commandService.run(KillScript.class, true, new Object[]{"editor", this});
    }

    public void runText() {
        this.runText(false);
    }

    public void runText(boolean selectionOnly) {
        if (this.isCompiled()) {
            if (selectionOnly) {
                this.error("Cannot run selection of compiled language!");
                return;
            }
            if (this.handleUnsavedChanges(true)) {
                this.runScript();
            } else {
                this.write("Compiled languages must be saved before they can be run.");
            }
            return;
        }
        ScriptLanguage currentLanguage = this.getCurrentLanguage();
        if (currentLanguage == null) {
            this.error("Select a language first!");
            return;
        }
        this.markCompileStart();
        try {
            TextEditorTab tab = this.getTab();
            tab.showOutput();
            this.execute(selectionOnly);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(boolean selectionOnly) throws IOException {
        final TextEditorTab tab = this.getTab();
        tab.prepare();
        JTextAreaWriter output = new JTextAreaWriter(tab.screen, this.log);
        JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
        final File file = this.getEditorPane().getFile();
        final PipedInputStream pi = new PipedInputStream();
        final PipedOutputStream po = new PipedOutputStream(pi);
        tab.setExecutor(new Executer(output, errors){

            @Override
            public void execute() {
                try {
                    TextEditor.this.evalScript(file == null ? TextEditor.this.getEditorPane().getFileName() : file.getAbsolutePath(), new InputStreamReader(pi), this.output, this.errors);
                    this.output.flush();
                    this.errors.flush();
                    TextEditor.this.markCompileEnd();
                }
                catch (Throwable t) {
                    this.output.flush();
                    this.errors.flush();
                    if (t instanceof ScriptException && t.getCause() != null && t.getCause().getClass().getName().endsWith("CompileError")) {
                        TextEditor.this.errorScreen.append("Compilation failed");
                        tab.showErrors();
                    } else {
                        TextEditor.this.handleException(t);
                    }
                }
                finally {
                    tab.restore();
                }
            }
        });
        try {
            String text;
            if (selectionOnly) {
                String selected = tab.getEditorPane().getSelectedText();
                if (selected == null) {
                    this.error("Selection required!");
                    text = null;
                } else {
                    text = selected + "\n";
                }
            } else {
                text = tab.getEditorPane().getText();
            }
            new Thread(){
                {
                    this.setPriority(5);
                }

                @Override
                public void run() {
                    try (PrintWriter pw = new PrintWriter(po);){
                        pw.write(text);
                        pw.flush();
                    }
                }
            }.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            tab.getEditorPane().setEditable(true);
        }
    }

    public void runScript() {
        if (this.isCompiled()) {
            this.getTab().showErrors();
        } else {
            this.getTab().showOutput();
        }
        this.markCompileStart();
        JTextAreaWriter output = new JTextAreaWriter(this.getTab().screen, this.log);
        JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
        final File file = this.getEditorPane().getFile();
        new Executer(output, errors){

            @Override
            public void execute() {
                try (Reader reader = TextEditor.this.evalScript(TextEditor.this.getEditorPane().getFile().getPath(), new FileReader(file), this.output, this.errors);){
                    this.output.flush();
                    this.errors.flush();
                    TextEditor.this.markCompileEnd();
                }
                catch (Throwable e) {
                    TextEditor.this.handleException(e);
                }
            }
        };
    }

    public void compile() {
        if (!this.handleUnsavedChanges(true)) {
            return;
        }
        ScriptEngine interpreter = this.getCurrentLanguage().getScriptEngine();
        if (interpreter instanceof JavaEngine) {
            final JavaEngine java = (JavaEngine)interpreter;
            final JTextAreaWriter errors = new JTextAreaWriter(this.errorScreen, this.log);
            this.markCompileStart();
            this.getTab().showErrors();
            new Thread(){

                @Override
                public void run() {
                    java.compile(TextEditor.this.getEditorPane().getFile(), (Writer)errors);
                    TextEditor.this.errorScreen.insert("Compilation finished.\n", TextEditor.this.errorScreen.getDocument().getLength());
                    TextEditor.this.markCompileEnd();
                }
            }.start();
        }
    }

    public String getSelectedTextOrAsk(String label) {
        String selection = this.getTextArea().getSelectedText();
        if ((selection == null || selection.indexOf(10) >= 0) && (selection = JOptionPane.showInputDialog(this, label + ":", label + "...", 3)) == null) {
            return null;
        }
        return selection;
    }

    public String getSelectedClassNameOrAsk() {
        String className = this.getSelectedTextOrAsk("Class name");
        if (className != null) {
            className = className.trim();
        }
        return className;
    }

    private static void append(JTextArea textArea, String text) {
        int length = textArea.getDocument().getLength();
        textArea.insert(text, length);
        textArea.setCaretPosition(length);
    }

    public void markCompileStart() {
        this.errorHandler = null;
        String started = "Started " + this.getEditorPane().getFileName() + " at " + new Date() + "\n";
        int offset = this.errorScreen.getDocument().getLength();
        TextEditor.append(this.errorScreen, started);
        TextEditor.append(this.getTab().screen, started);
        this.compileStartOffset = this.errorScreen.getDocument().getLength();
        try {
            this.compileStartPosition = this.errorScreen.getDocument().createPosition(offset);
        }
        catch (BadLocationException e) {
            this.handleException(e);
        }
        ExceptionHandler.addThread(Thread.currentThread(), this);
    }

    public void markCompileEnd() {
        if (this.errorHandler == null) {
            this.errorHandler = new ErrorHandler(this.getCurrentLanguage(), this.errorScreen, this.compileStartPosition.getOffset());
            if (this.errorHandler.getErrorCount() > 0) {
                this.getTab().showErrors();
            }
        }
        if (this.compileStartOffset != this.errorScreen.getDocument().getLength()) {
            this.getTab().showErrors();
        }
        if (this.getTab().showingErrors) {
            this.errorHandler.scrollToVisible(this.compileStartOffset);
        }
    }

    public boolean nextError(boolean forward) {
        if (this.errorHandler != null && this.errorHandler.nextError(forward)) {
            try {
                File file = new File(this.errorHandler.getPath());
                if (!file.isAbsolute()) {
                    file = this.getFileForBasename(file.getName());
                }
                this.errorHandler.markLine();
                this.switchTo(file, this.errorHandler.getLine());
                this.getTab().showErrors();
                this.errorScreen.invalidate();
                return true;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return false;
    }

    public void switchTo(String path, int lineNumber) throws IOException {
        this.switchTo(new File(path).getCanonicalFile(), lineNumber);
    }

    public void switchTo(File file, final int lineNumber) {
        if (!this.editorPaneContainsFile(this.getEditorPane(), file)) {
            this.switchTo(file);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TextEditor.this.gotoLine(lineNumber);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public void switchTo(File file) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (!this.editorPaneContainsFile(this.getEditorPane(i), file)) continue;
            this.switchTo(i);
            return;
        }
        this.open(file);
    }

    public void switchTo(int index) {
        if (index == this.tabbed.getSelectedIndex()) {
            return;
        }
        this.tabbed.setSelectedIndex(index);
    }

    private void switchTabRelative(int delta) {
        int count = this.tabbed.getTabCount();
        int index = (this.tabbed.getSelectedIndex() + delta) % count;
        if (index < 0) {
            index += count;
        }
        this.switchTo(index);
    }

    private void removeTab(int index) {
        int menuItemIndex = index + this.tabsMenuTabsStart;
        this.tabbed.remove(index);
        this.tabsMenuItems.remove(this.tabsMenu.getItem(menuItemIndex));
        this.tabsMenu.remove(menuItemIndex);
    }

    boolean editorPaneContainsFile(EditorPane editorPane, File file) {
        try {
            return file != null && editorPane != null && editorPane.getFile() != null && file.getCanonicalFile().equals(editorPane.getFile().getCanonicalFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getFile() {
        return this.getEditorPane().getFile();
    }

    public File getFileForBasename(String baseName) {
        File file = this.getFile();
        if (file != null && file.getName().equals(baseName)) {
            return file;
        }
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            file = this.getEditorPane(i).getFile();
            if (file == null || !file.getName().equals(baseName)) continue;
            return file;
        }
        return null;
    }

    private void updateGitDirectory() {
        EditorPane editorPane = this.getEditorPane();
        editorPane.setGitDirectory(new FileFunctions(this).getGitDirectory(editorPane.getFile()));
    }

    public void addImport(String className) {
        if (className != null) {
            new TokenFunctions(this.getTextArea()).addImport(className.trim());
        }
    }

    public void openHelp(String className) {
        this.openHelp(className, true);
    }

    public void openHelp(String className, boolean withFrames) {
        if (className == null) {
            this.getSelectedClassNameOrAsk();
        }
    }

    public void extractSourceJar() {
        File file = this.openWithDialog(null);
        if (file != null) {
            this.extractSourceJar(file);
        }
    }

    public void extractSourceJar(File file) {
        try {
            FileFunctions functions = new FileFunctions(this);
            File workspace = this.uiService.chooseFile(new File(System.getProperty("user.home")), "directory");
            if (workspace == null) {
                return;
            }
            List<String> paths = functions.extractSourceJar(file.getAbsolutePath(), workspace);
            for (String path : paths) {
                if (functions.isBinaryFile(path)) continue;
                this.open(new File(path));
                EditorPane pane = this.getEditorPane();
                new TokenFunctions(pane).removeTrailingWhitespace();
                if (!pane.fileChanged()) continue;
                this.save();
            }
        }
        catch (IOException e) {
            this.error("There was a problem opening " + file + ": " + e.getMessage());
        }
    }

    private File openWithDialog(File defaultDir) {
        return this.uiService.chooseFile(defaultDir, "open");
    }

    public void write(String message) {
        TextEditorTab tab = this.getTab();
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        tab.screen.insert(message, tab.screen.getDocument().getLength());
    }

    public void writeError(String message) {
        this.getTab().showErrors();
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        this.errorScreen.insert(message, this.errorScreen.getDocument().getLength());
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void handleException(Throwable e) {
        TextEditor.handleException(e, this.errorScreen);
        this.getTab().showErrors();
    }

    public static void handleException(Throwable e, JTextArea textArea) {
        CharArrayWriter writer = new CharArrayWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            e.printStackTrace(out);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                out.write("Caused by: ");
                cause.printStackTrace(out);
            }
        }
        textArea.append(writer.toString());
    }

    public int zapGremlins() {
        int count = this.getEditorPane().zapGremlins();
        String msg = count > 0 ? "Zap Gremlins converted " + count + " invalid characters to spaces" : "No invalid characters found!";
        JOptionPane.showMessageDialog(this, msg);
        return count;
    }

    private boolean isCompiled() {
        ScriptLanguage language = this.getCurrentLanguage();
        if (language == null) {
            return false;
        }
        return language.isCompiledLanguage();
    }

    private Reader evalScript(String filename, Reader reader, Writer output, Writer errors) throws ModuleException {
        ScriptLanguage language = this.getCurrentLanguage();
        if (this.respectAutoImports) {
            reader = DefaultAutoImporters.prefixAutoImports(this.context, language, reader, errors);
        }
        ScriptInfo info = new ScriptInfo(this.context, filename, reader);
        ScriptModule module = info.createModule();
        this.context.inject((Object)module);
        module.setLanguage(language);
        module.setOutputWriter(output);
        module.setErrorWriter(errors);
        try {
            this.moduleService.run((Module)module, true, new Object[0]).get();
        }
        catch (InterruptedException e) {
            this.error("Interrupted");
        }
        catch (ExecutionException e) {
            this.log.error((Throwable)e);
        }
        return reader;
    }

    private String adjustPath(String path, String langName) {
        String result = path.replace('_', ' ');
        if (langName != null && path.toLowerCase().startsWith(langName.toLowerCase() + "/")) {
            result = "Uncategorized" + result.substring(langName.length());
        }
        return result;
    }

    public boolean confirmClose() {
        while (this.tabbed.getTabCount() > 0) {
            if (!this.handleUnsavedChanges()) {
                return false;
            }
            int index = this.tabbed.getSelectedIndex();
            this.removeTab(index);
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setTitle();
        this.checkForOutsideChanges();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setTitle();
        this.checkForOutsideChanges();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setTitle();
    }

    static {
        TextEditor.addTemplatePath("script_templates");
        TextEditor.addTemplatePath("script-templates");
        tokenMakerFactory = null;
    }

    public abstract class Executer
    extends ThreadGroup {
        JTextAreaWriter output;
        JTextAreaWriter errors;

        Executer(final JTextAreaWriter output, final JTextAreaWriter errors) {
            super("Script Editor Run :: " + new Date().toString());
            this.output = output;
            this.errors = errors;
            TextEditor.this.executingTasks.add(this);
            TextEditor.this.setTitle();
            TextEditor.this.kill.setEnabled(true);
            new Thread(this, this.getName()){
                {
                    super(x0, x1);
                    this.setPriority(5);
                    this.start();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block21: {
                        Executer.this.execute();
                        int activeCount = this.getThreadGroup().activeCount();
                        while (activeCount > 1 && !this.isInterrupted()) {
                            try {
                                Thread.sleep(500L);
                                List<Thread> ts = Executer.this.getAllThreads();
                                activeCount = ts.size();
                                if (activeCount <= 1) break;
                                TextEditor.this.log.debug((Object)("Waiting for " + ts.size() + " threads to die"));
                                int count_zSelector = 0;
                                for (Thread t : ts) {
                                    if (t.getName().equals("zSelector")) {
                                        ++count_zSelector;
                                    }
                                    TextEditor.this.log.debug((Object)("THREAD: " + t.getName()));
                                }
                                if (activeCount != count_zSelector + 1) continue;
                                break;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        TextEditor.this.executingTasks.remove(Executer.this);
                        try {
                            if (null != output) {
                                output.shutdown();
                            }
                            if (null != errors) {
                                errors.shutdown();
                            }
                        }
                        catch (Exception e) {
                            TextEditor.this.handleException(e);
                        }
                        TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                        TextEditor.this.setTitle();
                        break block21;
                        catch (Throwable t) {
                            try {
                                TextEditor.this.handleException(t);
                                TextEditor.this.executingTasks.remove(Executer.this);
                            }
                            catch (Throwable throwable) {
                                TextEditor.this.executingTasks.remove(Executer.this);
                                try {
                                    if (null != output) {
                                        output.shutdown();
                                    }
                                    if (null != errors) {
                                        errors.shutdown();
                                    }
                                }
                                catch (Exception e) {
                                    TextEditor.this.handleException(e);
                                }
                                TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                                TextEditor.this.setTitle();
                                throw throwable;
                            }
                            try {
                                if (null != output) {
                                    output.shutdown();
                                }
                                if (null != errors) {
                                    errors.shutdown();
                                }
                            }
                            catch (Exception e) {
                                TextEditor.this.handleException(e);
                            }
                            TextEditor.this.kill.setEnabled(TextEditor.this.executingTasks.size() > 0);
                            TextEditor.this.setTitle();
                        }
                    }
                }
            };
        }

        abstract void execute();

        List<Thread> getAllThreads() {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            ThreadGroup[] tgs = new ThreadGroup[this.activeGroupCount() * 2 + 100];
            this.enumerate(tgs, true);
            for (ThreadGroup tg : tgs) {
                if (null == tg) continue;
                Thread[] ts = new Thread[tg.activeCount() * 2 + 100];
                tg.enumerate(ts);
                for (Thread t : ts) {
                    if (null == t) continue;
                    threads.add(t);
                }
            }
            Thread[] ts = new Thread[this.activeCount() * 2 + 100];
            this.enumerate(ts);
            for (Thread t : ts) {
                if (null == t) continue;
                threads.add(t);
            }
            return threads;
        }

        void obliterate() {
            try {
                if (null != this.output) {
                    this.output.shutdownNow();
                }
                if (null != this.errors) {
                    this.errors.shutdownNow();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Thread thread : this.getAllThreads()) {
                try {
                    thread.interrupt();
                    Thread.yield();
                    thread.stop();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            TextEditor.this.executingTasks.remove(this);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    protected static class AcceleratorTriplet {
        JMenuItem component;
        int key;
        int modifiers;

        protected AcceleratorTriplet() {
        }
    }
}

