/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.XMLFileErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XMLFileWriter {
    private FilesCollection files;
    private TransformerHandler handler;
    private final String XALAN_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String dtd = "<!DOCTYPE pluginRecords [\n<!ELEMENT pluginRecords ((update-site | disabled-update-site)*, plugin*)>\n<!ELEMENT update-site EMPTY>\n<!ELEMENT disabled-update-site EMPTY>\n<!ELEMENT plugin (platform*, category*, version?, previous-version*)>\n<!ELEMENT version (description?, dependency*, link*, author*)>\n<!ELEMENT previous-version EMPTY>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT dependency EMPTY>\n<!ELEMENT link (#PCDATA)>\n<!ELEMENT author (#PCDATA)>\n<!ELEMENT platform (#PCDATA)>\n<!ELEMENT category (#PCDATA)>\n<!ATTLIST update-site name CDATA #REQUIRED>\n<!ATTLIST update-site url CDATA #REQUIRED>\n<!ATTLIST update-site ssh-host CDATA #IMPLIED>\n<!ATTLIST update-site upload-directory CDATA #IMPLIED>\n<!ATTLIST update-site description CDATA #IMPLIED>\n<!ATTLIST update-site maintainer CDATA #IMPLIED>\n<!ATTLIST update-site timestamp CDATA #REQUIRED>\n<!ATTLIST disabled-update-site name CDATA #REQUIRED>\n<!ATTLIST disabled-update-site url CDATA #REQUIRED>\n<!ATTLIST disabled-update-site ssh-host CDATA #IMPLIED>\n<!ATTLIST disabled-update-site upload-directory CDATA #IMPLIED>\n<!ATTLIST disabled-update-site description CDATA #IMPLIED>\n<!ATTLIST disabled-update-site maintainer CDATA #IMPLIED>\n<!ATTLIST disabled-update-site timestamp CDATA #REQUIRED>\n<!ATTLIST plugin update-site CDATA #IMPLIED>\n<!ATTLIST plugin filename CDATA #REQUIRED>\n<!ATTLIST plugin executable CDATA #IMPLIED>\n<!ATTLIST dependency filename CDATA #REQUIRED>\n<!ATTLIST dependency timestamp CDATA #IMPLIED>\n<!ATTLIST dependency overrides CDATA #IMPLIED>\n<!ATTLIST version timestamp CDATA #REQUIRED>\n<!ATTLIST version checksum CDATA #REQUIRED>\n<!ATTLIST version filesize CDATA #REQUIRED>\n<!ATTLIST previous-version filename CDATA #IMPLIED>\n<!ATTLIST previous-version timestamp CDATA #REQUIRED>\n<!ATTLIST previous-version checksum CDATA #REQUIRED>]>\n";

    public XMLFileWriter(FilesCollection files) {
        this.files = files;
    }

    public byte[] toByteArray(boolean local) throws SAXException, TransformerConfigurationException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out, local);
        return out.toByteArray();
    }

    public byte[] toCompressedByteArray(boolean local) throws SAXException, TransformerConfigurationException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(new GZIPOutputStream(out), local);
        return out.toByteArray();
    }

    public void validate(boolean local) throws SAXException, TransformerConfigurationException, IOException, ParserConfigurationException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.toByteArray(local));
        this.validate(in);
    }

    public void write(OutputStream out, boolean local) throws SAXException, TransformerConfigurationException, IOException {
        this.createHandler(out);
        this.handler.startDocument();
        AttributesImpl attr = new AttributesImpl();
        this.handler.startElement("", "", "pluginRecords", attr);
        if (local) {
            for (String name : this.files.getUpdateSiteNames(true)) {
                attr.clear();
                UpdateSite site = this.files.getUpdateSite(name, true);
                this.setAttribute(attr, "name", name);
                this.setAttribute(attr, "url", site.getURL());
                if (site.getHost() != null) {
                    this.setAttribute(attr, "ssh-host", site.getHost());
                }
                if (site.getUploadDirectory() != null) {
                    this.setAttribute(attr, "upload-directory", site.getUploadDirectory());
                }
                if (site.getDescription() != null) {
                    this.setAttribute(attr, "description", site.getDescription());
                }
                if (site.getMaintainer() != null) {
                    this.setAttribute(attr, "description", site.getMaintainer());
                }
                this.setAttribute(attr, "timestamp", "" + site.getTimestamp());
                this.writeSimpleTag((site.isActive() ? "" : "disabled-") + "update-site", null, attr);
            }
        }
        for (FileObject file : this.files.managedFiles()) {
            this.writeSingle(local, attr, file);
        }
        this.handler.endElement("", "", "pluginRecords");
        this.handler.endDocument();
        out.flush();
        out.close();
    }

    protected void writeSingle(boolean local, AttributesImpl attr, FileObject file) throws SAXException {
        attr.clear();
        assert (file.updateSite != null && !file.updateSite.equals(""));
        if (local) {
            this.setAttribute(attr, "update-site", file.updateSite);
        }
        this.setAttribute(attr, "filename", file.filename);
        if (file.executable) {
            this.setAttribute(attr, "executable", "true");
        }
        this.handler.startElement("", "", "plugin", attr);
        this.writeSimpleTags("platform", file.getPlatforms());
        this.writeSimpleTags("category", file.getCategories());
        FileObject.Version current = file.current;
        if (file.getChecksum() != null) {
            attr.clear();
            this.setAttribute(attr, "checksum", file.getChecksum());
            this.setAttribute(attr, "timestamp", file.getTimestamp());
            this.setAttribute(attr, "filesize", file.filesize);
            this.handler.startElement("", "", "version", attr);
            if (file.description != null) {
                this.writeSimpleTag("description", file.description);
            }
            for (Dependency dependency : file.getDependencies()) {
                attr.clear();
                this.setAttribute(attr, "filename", dependency.filename);
                this.setAttribute(attr, "timestamp", dependency.timestamp);
                if (dependency.overrides) {
                    this.setAttribute(attr, "overrides", "true");
                }
                this.writeSimpleTag("dependency", null, attr);
            }
            this.writeSimpleTags("link", file.getLinks());
            this.writeSimpleTags("author", file.getAuthors());
            this.handler.endElement("", "", "version");
        }
        if (current != null && !current.checksum.equals(file.getChecksum())) {
            file.addPreviousVersion(current.checksum, current.timestamp, current.filename);
        }
        for (FileObject.Version version : file.getPrevious()) {
            attr.clear();
            this.setAttribute(attr, "timestamp", version.timestamp);
            this.setAttribute(attr, "checksum", version.checksum);
            if (version.filename != null) {
                this.setAttribute(attr, "filename", version.filename);
            }
            this.writeSimpleTag("previous-version", null, attr);
        }
        this.handler.endElement("", "", "plugin");
    }

    protected void setAttribute(AttributesImpl attributes, String key, long value) {
        this.setAttribute(attributes, key, "" + value);
    }

    protected void setAttribute(AttributesImpl attributes, String key, String value) {
        attributes.addAttribute("", "", key, "CDATA", value);
    }

    protected void writeSimpleTags(String tagName, Iterable<String> values) throws SAXException {
        for (String value : values) {
            this.writeSimpleTag(tagName, value);
        }
    }

    protected void writeSimpleTag(String tagName, String value) throws SAXException {
        this.writeSimpleTag(tagName, value, new AttributesImpl());
    }

    protected void writeSimpleTag(String tagName, String value, AttributesImpl attributes) throws SAXException {
        this.handler.startElement("", "", tagName, attributes);
        if (value != null) {
            this.handler.characters(value.toCharArray(), 0, value.length());
        }
        this.handler.endElement("", "", tagName);
    }

    protected void createHandler(OutputStream outputStream) throws TransformerConfigurationException {
        StreamResult streamResult = new StreamResult(new DTDInserter(outputStream));
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.handler = tf.newTransformerHandler();
        Transformer serializer = this.handler.getTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        this.handler.setResult(streamResult);
    }

    protected void validate(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        XMLReader xr = parser.getXMLReader();
        xr.setErrorHandler(new XMLFileErrorHandler());
        xr.parse(new InputSource(inputStream));
        inputStream.close();
    }

    static class DTDInserter
    extends OutputStream {
        private final OutputStream out;
        private boolean dtdInserted;

        DTDInserter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            if (!this.dtdInserted) {
                throw new IOException("DTD not inserted!");
            }
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.insertDTDIfNecessary(b, off, len)) {
                this.out.write(b, off, len);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!this.insertDTDIfNecessary(b, 0, b.length)) {
                this.out.write(b);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        private boolean insertDTDIfNecessary(byte[] b, int off, int len) throws IOException {
            if (this.dtdInserted) {
                return false;
            }
            int found = off + new String(b, off, len).indexOf("<pluginRecords>");
            if (found < 0) {
                found = off + new String(b, off, len).indexOf("<pluginRecords/>");
            }
            if (found < 0) {
                return false;
            }
            if (found > off) {
                this.out.write(b, off, found - off);
            }
            this.out.write(XMLFileWriter.dtd.getBytes());
            this.out.write(b, found, len - found);
            this.dtdInserted = true;
            return true;
        }
    }
}

