/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.imagej.updater.Conflicts;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdaterUI;
import net.imagej.updater.util.Downloadable;
import net.imagej.updater.util.Downloader;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;

public class Installer
extends Downloader {
    private FilesCollection files;
    protected static final String UPDATER_JAR_NAME = "jars/imagej-updater.jar";

    public Installer(FilesCollection files, Progress progress) {
        super(progress, files.util);
        this.files = files;
        if (progress != null) {
            this.addProgress(progress);
        }
        this.addProgress(new VerifyFiles());
    }

    public synchronized void start() throws IOException {
        Iterable<Conflicts.Conflict> conflicts = new Conflicts(this.files).getConflicts(false);
        if (Conflicts.needsFeedback(conflicts)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unresolved conflicts:\n");
            for (Conflicts.Conflict conflict : conflicts) {
                builder.append(conflict.getFilename()).append(": ").append(conflict.getConflict());
            }
            throw new RuntimeException(builder.toString());
        }
        FilesCollection uninstalled = this.files.clone(this.files.toUninstall());
        for (FileObject file : uninstalled) {
            try {
                file.stageForUninstall(this.files);
            }
            catch (IOException e) {
                this.files.log.error((Throwable)e);
                throw new RuntimeException("Could not mark '" + file + "' for removal");
            }
        }
        ArrayList<Downloadable> list = new ArrayList<Downloadable>();
        for (FileObject file : this.files.toInstallOrUpdate()) {
            String name = file.filename;
            File saveTo = this.files.prefixUpdate(name);
            if (file.localFilename != null && !file.localFilename.equals(file.filename)) {
                FileObject.touch(this.files.prefixUpdate(file.localFilename));
            }
            if (file.executable) {
                File old;
                saveTo = this.files.prefix(name);
                String oldName = saveTo.getAbsolutePath() + ".old";
                if (oldName.endsWith(".exe.old")) {
                    oldName = oldName.substring(0, oldName.length() - 8) + ".old.exe";
                }
                if ((old = new File(oldName)).exists()) {
                    old.delete();
                }
                saveTo.renameTo(old);
                if (name.equals("Contents/MacOS/ImageJ-tiger")) {
                    try {
                        UpdaterUtil.patchInfoPList(this.files.prefix("Contents/Info.plist"), "ImageJ-tiger");
                    }
                    catch (IOException e) {
                        UpdaterUserInterface.get().error("Could not patch Info.plist");
                    }
                }
            }
            String url = this.files.getURL(file);
            Download download = new Download(file, url, saveTo);
            list.add(download);
        }
        this.start(list);
        for (FileObject file : uninstalled) {
            if (file.isLocalOnly()) {
                this.files.remove(file);
                continue;
            }
            file.setStatus(file.isObsolete() ? FileObject.Status.OBSOLETE_UNINSTALLED : FileObject.Status.NOT_INSTALLED);
        }
    }

    public static Set<FileObject> getUpdaterFiles(FilesCollection files, CommandService commandService, boolean onlyUpdateable) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        FileObject updater = files.get(UPDATER_JAR_NAME);
        if (updater == null) {
            return result;
        }
        HashSet<FileObject> topLevel = new HashSet<FileObject>();
        topLevel.add(updater);
        if (commandService == null) {
            String hardcoded = "jars/imagej-ui-swing.jar";
            FileObject file = files.get("jars/imagej-ui-swing.jar");
            if (file != null) {
                topLevel.add(file);
            }
        } else {
            for (CommandInfo info : commandService.getCommandsOfType(UpdaterUI.class)) {
                FileObject file = Installer.getFileObject(files, info.getClassName());
                if (file == null) continue;
                topLevel.add(file);
            }
        }
        for (FileObject file : topLevel) {
            for (FileObject file2 : file.getFileDependencies(files, true)) {
                if (!onlyUpdateable) {
                    result.add(file2);
                    continue;
                }
                switch (file2.getStatus()) {
                    case NEW: 
                    case NOT_INSTALLED: 
                    case UPDATEABLE: {
                        result.add(file2);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static FileObject getFileObject(FilesCollection files, String className) {
        try {
            String path = "/" + className.replace('.', '/') + ".class";
            String jar = Installer.class.getClassLoader().loadClass(className).getResource(path).toString();
            if (!jar.endsWith(".jar!" + path)) {
                return null;
            }
            jar = jar.substring(0, jar.length() - path.length() - 1);
            String prefix = "jar:file:" + System.getProperty("ij.dir");
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if (!jar.startsWith(prefix)) {
                return null;
            }
            jar = jar.substring(prefix.length());
            return files.get(jar);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isTheUpdaterUpdateable(FilesCollection files) {
        return Installer.isTheUpdaterUpdateable(files, null);
    }

    public static boolean isTheUpdaterUpdateable(FilesCollection files, CommandService commandService) {
        return Installer.getUpdaterFiles(files, commandService, true).size() > 0;
    }

    public static void updateTheUpdater(FilesCollection files, Progress progress) throws IOException {
        Installer.updateTheUpdater(files, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTheUpdater(FilesCollection files, Progress progress, CommandService commandService) throws IOException {
        final Set<FileObject> all = Installer.getUpdaterFiles(files, commandService, true);
        int counter = 0;
        for (FileObject file : all) {
            if (!file.setFirstValidAction(files, FileObject.Action.UPDATE, FileObject.Action.INSTALL)) continue;
            ++counter;
        }
        if (counter == 0) {
            return;
        }
        FilesCollection.Filter filter = new FilesCollection.Filter(){

            @Override
            public boolean matches(FileObject file) {
                return all.contains(file);
            }
        };
        FilesCollection justTheUpdater = files.clone(files.filter(filter));
        Installer installer = new Installer(justTheUpdater, progress);
        try {
            installer.start();
        }
        finally {
            installer.done();
        }
    }

    public void verify(Download download) {
        String actualDigest;
        File destination = download.getDestination();
        long size = download.getFilesize();
        long actualSize = destination.length();
        if (size >= 0L && size != actualSize) {
            throw new RuntimeException("Incorrect file size for " + destination + ": " + actualSize + " (expected " + size + ")");
        }
        FileObject file = download.file;
        String digest = download.file.getChecksum();
        try {
            List<String> obsoletes;
            actualDigest = UpdaterUtil.getDigest(file.getFilename(), destination);
            if (!digest.equals(actualDigest) && (obsoletes = UpdaterUtil.getObsoleteDigests(file.getFilename(), destination)) != null) {
                for (String obsolete : obsoletes) {
                    if (!digest.equals(obsolete)) continue;
                    actualDigest = obsolete;
                }
            }
        }
        catch (Exception e) {
            this.files.log.error((Throwable)e);
            throw new RuntimeException("Could not verify checksum for " + destination);
        }
        if (!digest.equals(actualDigest)) {
            throw new RuntimeException("Incorrect checksum for " + destination + ":\n" + actualDigest + "\n(expected " + digest + ")");
        }
        file.setLocalVersion(file.getFilename(), digest, file.getTimestamp());
        file.setStatus(FileObject.Status.INSTALLED);
        if (file.executable && !this.files.util.platform.startsWith("win")) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "0755", download.destination.getAbsolutePath()});
            }
            catch (Exception e) {
                this.files.log.error((Throwable)e);
                throw new RuntimeException("Could not mark " + destination + " as executable");
            }
        }
    }

    public void moveUpdatedIntoPlace() throws IOException {
        this.moveUpdatedIntoPlace(this.files.prefix("update"), this.files.prefix("."));
    }

    protected void moveUpdatedIntoPlace(File sourceDirectory, File targetDirectory) throws IOException {
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        File[] list = sourceDirectory.listFiles();
        if (list == null) {
            return;
        }
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdir()) {
            throw new IOException("Could not create directory '" + targetDirectory + "'");
        }
        for (File file : list) {
            File targetFile = new File(targetDirectory, file.getName());
            if (file.isDirectory()) {
                this.moveUpdatedIntoPlace(file, targetFile);
                continue;
            }
            if (!file.isFile()) continue;
            if (file.length() == 0L) {
                if (targetFile.exists()) {
                    Installer.deleteOrThrowException(targetFile);
                }
                Installer.deleteOrThrowException(file);
                continue;
            }
            if (file.renameTo(targetFile) || (targetFile.delete() || Installer.moveOutOfTheWay(targetFile)) && file.renameTo(targetFile)) continue;
            throw new IOException("Could not move '" + file + "' to '" + targetFile + "'");
        }
        Installer.deleteOrThrowException(sourceDirectory);
    }

    protected static void deleteOrThrowException(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Could not remove '" + file + "'");
        }
    }

    protected static boolean moveOutOfTheWay(File file) {
        File backup;
        block3: {
            if (!file.exists()) {
                return true;
            }
            String prefix = file.getName();
            String suffix = "";
            if (prefix.endsWith(".exe") || prefix.endsWith(".EXE") || prefix.endsWith(".dll") || prefix.endsWith(".DLL")) {
                suffix = prefix.substring(prefix.length() - 4);
                prefix = prefix.substring(0, prefix.length() - 4);
            }
            if (!(backup = new File(file.getParentFile(), prefix + ".old" + suffix)).exists() || backup.delete()) break block3;
            int i = 2;
            while ((backup = new File(file.getParentFile(), prefix + ".old" + 2 + suffix)).exists()) {
            }
        }
        return file.renameTo(backup);
    }

    class VerifyFiles
    implements Progress {
        VerifyFiles() {
        }

        @Override
        public void itemDone(Object item) {
            Installer.this.verify((Download)item);
        }

        @Override
        public void setTitle(String title) {
        }

        @Override
        public void setCount(int count, int total) {
        }

        @Override
        public void addItem(Object item) {
        }

        @Override
        public void setItemCount(int count, int total) {
        }

        @Override
        public void done() {
        }
    }

    class Download
    implements Downloadable {
        protected FileObject file;
        protected String url;
        protected File destination;

        Download(FileObject file, String url, File destination) {
            this.file = file;
            this.url = url;
            this.destination = destination;
        }

        public String toString() {
            return this.file.getFilename();
        }

        @Override
        public File getDestination() {
            return this.destination;
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public long getFilesize() {
            return this.file.filesize;
        }
    }
}

