/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.imglib2.type.numeric.IntegerType;

public class UnboundedIntegerType
implements IntegerType<UnboundedIntegerType> {
    private BigInteger v;

    public UnboundedIntegerType() {
        this.set(BigInteger.ZERO);
    }

    public UnboundedIntegerType(UnboundedIntegerType other) {
        this.set(other);
    }

    public UnboundedIntegerType(long val) {
        this.set(val);
    }

    public UnboundedIntegerType(BigInteger val) {
        this.set(val);
    }

    public BigInteger get() {
        return this.v;
    }

    public void set(long val) {
        this.v = BigInteger.valueOf(val);
    }

    public void set(BigInteger val) {
        this.v = val;
    }

    public UnboundedIntegerType createVariable() {
        return new UnboundedIntegerType();
    }

    public UnboundedIntegerType copy() {
        return new UnboundedIntegerType(this);
    }

    public void set(UnboundedIntegerType val) {
        this.v = val.v;
    }

    public void add(UnboundedIntegerType val) {
        this.v = this.v.add(val.v);
    }

    public void sub(UnboundedIntegerType val) {
        this.v = this.v.subtract(val.v);
    }

    public void mul(UnboundedIntegerType val) {
        this.v = this.v.multiply(val.v);
    }

    public void div(UnboundedIntegerType val) {
        this.v = this.v.divide(val.v);
    }

    public void setZero() {
        this.v = BigInteger.ZERO;
    }

    public void setOne() {
        this.v = BigInteger.ONE;
    }

    public void mul(float val) {
        this.doMul(BigDecimal.valueOf(val));
    }

    public void mul(double val) {
        this.doMul(BigDecimal.valueOf(val));
    }

    public void mul(BigInteger val) {
        this.v = this.v.multiply(val);
    }

    public void mul(BigDecimal val) {
        this.doMul(val);
    }

    private void doMul(BigDecimal factor) {
        BigDecimal val = new BigDecimal(this.v);
        BigDecimal result = val.multiply(factor);
        this.v = result.toBigInteger();
    }

    public void inc() {
        this.v = this.v.add(BigInteger.ONE);
    }

    public void dec() {
        this.v = this.v.subtract(BigInteger.ONE);
    }

    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    public double getMinValue() {
        return -1.7976931348623157E308;
    }

    public double getMinIncrement() {
        return Double.MIN_VALUE;
    }

    public int getBitsPerPixel() {
        return 1024;
    }

    public double getRealDouble() {
        return this.v.doubleValue();
    }

    public float getRealFloat() {
        return this.v.floatValue();
    }

    public double getImaginaryDouble() {
        return 0.0;
    }

    public float getImaginaryFloat() {
        return 0.0f;
    }

    public void setReal(float f) {
        this.set((long)f);
    }

    public void setReal(double f) {
        this.set((long)f);
    }

    public void setImaginary(float f) {
    }

    public void setImaginary(double f) {
    }

    public void setComplexNumber(float r, float i) {
        this.setReal(r);
    }

    public void setComplexNumber(double r, double i) {
        this.setReal(r);
    }

    public float getPowerFloat() {
        return this.v.floatValue();
    }

    public double getPowerDouble() {
        return this.v.doubleValue();
    }

    public float getPhaseFloat() {
        return 0.0f;
    }

    public double getPhaseDouble() {
        return 0.0;
    }

    public void complexConjugate() {
    }

    public int compareTo(UnboundedIntegerType o) {
        return this.v.compareTo(o.v);
    }

    public int getInteger() {
        return this.v.intValue();
    }

    public long getIntegerLong() {
        return this.v.longValue();
    }

    public BigInteger getBigInteger() {
        return this.v;
    }

    public void setInteger(int f) {
        this.set(f);
    }

    public void setInteger(long f) {
        this.set(f);
    }

    public void setBigInteger(BigInteger v) {
        this.v = v;
    }

    public boolean valueEquals(UnboundedIntegerType t) {
        return Objects.equals(this.get(), t.get());
    }

    public String toString() {
        return this.get().toString();
    }
}

