/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.org.xml.sax.helpers;

import java.io.IOException;
import java.util.Locale;
import org.scijava.jython.shaded.org.xml.sax.AttributeList;
import org.scijava.jython.shaded.org.xml.sax.Attributes;
import org.scijava.jython.shaded.org.xml.sax.ContentHandler;
import org.scijava.jython.shaded.org.xml.sax.DTDHandler;
import org.scijava.jython.shaded.org.xml.sax.DocumentHandler;
import org.scijava.jython.shaded.org.xml.sax.EntityResolver;
import org.scijava.jython.shaded.org.xml.sax.ErrorHandler;
import org.scijava.jython.shaded.org.xml.sax.InputSource;
import org.scijava.jython.shaded.org.xml.sax.Locator;
import org.scijava.jython.shaded.org.xml.sax.Parser;
import org.scijava.jython.shaded.org.xml.sax.SAXException;
import org.scijava.jython.shaded.org.xml.sax.SAXNotSupportedException;
import org.scijava.jython.shaded.org.xml.sax.XMLReader;
import org.scijava.jython.shaded.org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderAdapter
implements Parser,
ContentHandler {
    XMLReader xmlReader;
    DocumentHandler documentHandler;
    AttributesAdapter qAtts;

    public XMLReaderAdapter() throws SAXException {
        this.setup(XMLReaderFactory.createXMLReader());
    }

    public XMLReaderAdapter(XMLReader xMLReader) {
        this.setup(xMLReader);
    }

    private void setup(XMLReader xMLReader) {
        if (xMLReader == null) {
            throw new NullPointerException("XMLReader must not be null");
        }
        this.xmlReader = xMLReader;
        this.qAtts = new AttributesAdapter();
    }

    public void setLocale(Locale locale2) throws SAXException {
        throw new SAXNotSupportedException("setLocale not supported");
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.xmlReader.setDTDHandler(dTDHandler);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
    }

    public void parse(String string2) throws IOException, SAXException {
        this.parse(new InputSource(string2));
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.setupXMLReader();
        this.xmlReader.parse(inputSource);
    }

    private void setupXMLReader() throws SAXException {
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        try {
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.xmlReader.setContentHandler(this);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    public void startPrefixMapping(String string2, String string3) {
    }

    public void endPrefixMapping(String string2) {
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (this.documentHandler != null) {
            this.qAtts.setAttributes(attributes);
            this.documentHandler.startElement(string4, this.qAtts);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(string4);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(string2, string3);
        }
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    final class AttributesAdapter
    implements AttributeList {
        private Attributes attributes;

        AttributesAdapter() {
        }

        void setAttributes(Attributes attributes) {
            this.attributes = attributes;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getName(int n) {
            return this.attributes.getQName(n);
        }

        public String getType(int n) {
            return this.attributes.getType(n);
        }

        public String getValue(int n) {
            return this.attributes.getValue(n);
        }

        public String getType(String string2) {
            return this.attributes.getType(string2);
        }

        public String getValue(String string2) {
            return this.attributes.getValue(string2);
        }
    }
}

