/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.distributions.SignRank;

public class PsiGamma {
    @Internal
    @DataParallel
    public static double psigamma(double x, double deriv) {
        if (DoubleVector.isNaN(x)) {
            return x;
        }
        deriv = Math.floor(deriv + 0.5);
        int n = (int)deriv;
        double[] ans = new double[1];
        double[] xd = new double[]{x};
        int[] nz = new int[1];
        int[] ierr = new int[1];
        dpsifn.dpsifn(x, n, 1, 1, ans, nz, ierr);
        ans[0] = -ans[0];
        for (int k = 1; k <= n; ++k) {
            ans[0] = ans[0] * (double)(-k);
        }
        return ans[0];
    }

    public static class dpsifn {
        static final double[] bvalues = new double[]{1.0, -0.5, 0.16666666666666666, -0.03333333333333333, 0.023809523809523808, -0.03333333333333333, 0.07575757575757576, -0.2531135531135531, 1.1666666666666667, -7.092156862745098, 54.971177944862156, -529.1242424242424, 6192.123188405797, -86580.25311355312, 1425517.1666666667, -2.7298231067816094E7, 6.015808739006424E8, -1.5116315767092157E10, 4.296146430611667E11, -1.3711655205088332E13, 4.883323189735932E14, -1.9296579341940068E16};
        static final int n_max = 100;
        static int i;
        static int j;
        static int k;
        static int mm;
        static int mx;
        static int nn;
        static int np;
        static int nx;
        static int fn;
        static double arg;
        static double den;
        static double elim;
        static double eps;
        static double fln;
        static double fx;
        static double rln;
        static double rxsq;
        static double r1m4;
        static double r1m5;
        static double s;
        static double slope;
        static double t;
        static double ta;
        static double tk;
        static double tol;
        static double tols;
        static double tss;
        static double tst;
        static double tt;
        static double t1;
        static double t2;
        static double wdtol;
        static double xdmln;
        static double xdmy;
        static double xinc;
        static double xln;
        static double xm;
        static double xmin;
        static double xq;
        static double yint;
        static double[] trm;
        static double[] trmr;
        static int[] ierr;
        static double x;
        static int kode;
        static double[] ans;
        static int[] nz;

        public static void dpsifn(double x, int n, int kode, int m, double[] ans, int[] nz, int[] ierr) {
            block30: {
                dpsifn.x = x;
                dpsifn.kode = kode;
                dpsifn.ans = ans;
                dpsifn.nz = nz;
                dpsifn.ierr = ierr;
                if (n < 0 || kode < 1 || kode > 2 || m < 1) {
                    ierr[0] = 1;
                    return;
                }
                if (x <= 0.0) {
                    if (x == (double)((long)x)) {
                        for (j = 0; j < m; ++j) {
                            ans[dpsifn.j] = (j + n) % 2 != 0 ? Double.POSITIVE_INFINITY : Double.NaN;
                        }
                        return;
                    }
                    dpsifn.dpsifn(1.0 - x, n, 1, m, ans, nz, ierr);
                    if (m > 1 || n > 3) {
                        ierr[0] = 4;
                        return;
                    }
                    tt = n == 0 ? Math.cos(x) / Math.sin(x) : (n == 1 ? -1.0 / Math.pow(Math.sin(x), 2.0) : (n == 2 ? 2.0 * Math.cos(x) / Math.pow(Math.sin(x), 3.0) : (n == 3 ? -2.0 * (2.0 * Math.pow(Math.cos(x *= Math.PI), 2.0) + 1.0) / Math.pow(Math.sin(x), 4.0) : Double.NaN)));
                    s = n % 2 != 0 ? -1.0 : 1.0;
                    s = 1.0;
                    t2 = 1.0;
                    t1 = 1.0;
                    k = 0;
                    for (j = k - n; j < m; ++j) {
                        t1 *= Math.PI;
                        if (k >= 2) {
                            t2 *= (double)k;
                        }
                        if (j >= 0) {
                            ans[dpsifn.j] = s * (ans[j] + t1 / t2 * tt);
                        }
                        ++k;
                        s = -s;
                    }
                    if (n == 0 && kode == 2) {
                        ans[0] = ans[0] + xln;
                    }
                    return;
                }
                nz[0] = 0;
                xln = Math.log(x);
                if (kode == 1 && m == 1) {
                    double lrg = 1.0 / (2.0 * SignRank.DBL_EPSILON);
                    if (n == 0 && x * xln > lrg) {
                        ans[0] = -xln;
                        return;
                    }
                    if (n >= 1 && x > (double)n * lrg) {
                        ans[0] = Math.exp((double)(-n) * xln) / (double)n;
                        return;
                    }
                }
                mm = m;
                nx = Math.min(1022, 1023);
                r1m5 = 32.0;
                r1m4 = 0.0;
                wdtol = Math.max(r1m4, 5.0E-19);
                elim = 2.302 * ((double)nx * r1m5 - 3.0);
                do {
                    if (!(Math.abs(t = (double)((fn = (nn = n + mm - 1)) + 1) * xln) > elim)) {
                        if (x < wdtol) {
                            ans[0] = Math.pow(x, (double)(-n) - 1.0);
                            if (mm != 1) {
                                for (k = 1; k < mm; ++k) {
                                    ans[dpsifn.k] = ans[k - 1] / x;
                                }
                            }
                            if (n == 0 && kode == 2) {
                                ans[0] = ans[0] + xln;
                            }
                            return;
                        }
                        rln = r1m5 * 53.0;
                        rln = Math.min(rln, 18.06);
                        fln = Math.max(rln, 3.0) - 3.0;
                        yint = 3.5 + 0.4 * fln;
                        slope = 0.21 + fln * (6.038E-4 * fln + 0.008677);
                        xm = yint + slope * (double)fn;
                        mx = (int)xm + 1;
                        xmin = mx;
                        if (n != 0) {
                            xm = -2.302 * rln - Math.min(0.0, xln);
                            arg = xm / (double)n;
                            arg = Math.min(0.0, arg);
                            eps = Math.exp(arg);
                            xm = 1.0 - eps;
                            if (Math.abs(arg) < 0.001) {
                                xm = -arg;
                            }
                            fln = x * xm / eps;
                            xm = xmin - x;
                            if (xm > 7.0 && fln < 15.0) break block30;
                        }
                        xdmy = x;
                        xdmln = xln;
                        xinc = 0.0;
                        if (x < xmin) {
                            nx = (int)x;
                            xinc = xmin - (double)nx;
                            xdmy = x + xinc;
                            xdmln = Math.log(xdmy);
                        }
                        t = (double)fn * xdmln;
                        t1 = xdmln + xdmln;
                        t2 = t + xdmln;
                        tk = Math.max(Math.abs(t), Math.max(Math.abs(t1), Math.abs(t2)));
                        if (tk <= elim) {
                            dpsifn.L10();
                        }
                        return;
                    }
                    if (t <= 0.0) {
                        nz[0] = 0;
                        ierr[0] = 2;
                        return;
                    }
                    nz[0] = nz[0] + 1;
                    ans[--dpsifn.mm] = 0.0;
                } while (mm != 0);
                return;
            }
            nn = (int)fln + 1;
            np = n + 1;
            t1 = (double)(n + 1) * xln;
            s = t = Math.exp(-t1);
            den = x;
            for (i = 1; i <= nn; ++i) {
                dpsifn.trm[dpsifn.i] = Math.pow(den += 1.0, -np);
                s += trm[i];
            }
            ans[0] = s;
            if (n == 0 && kode == 2) {
                ans[0] = s + xln;
            }
            if (mm != 1) {
                tol = wdtol / 5.0;
                for (j = 1; j < mm; ++j) {
                    s = t /= x;
                    tols = t * tol;
                    den = x;
                    for (i = 1; i <= nn; ++i) {
                        int n2 = i;
                        trm[n2] = trm[n2] / (den += 1.0);
                        s += trm[i];
                        if (trm[i] < tols) break;
                    }
                    ans[dpsifn.j] = s;
                }
            }
        }

        private static void L20() {
            for (i = 1; i <= nx; ++i) {
                s += 1.0 / (x + (double)(nx - i));
            }
            dpsifn.L30();
        }

        public static void L30() {
            if (kode != 2) {
                dpsifn.ans[0] = s - xdmln;
            } else if (xdmy != x) {
                xq = xdmy / x;
                dpsifn.ans[0] = s - Math.log(xq);
            }
        }

        public static void L10() {
            tss = Math.exp(-t);
            t1 = tt = 0.5 / xdmy;
            tst = wdtol * tt;
            if (nn != 0) {
                t1 = tt + 1.0 / (double)fn;
            }
            if (Math.abs(s = (t = (double)(fn + 1) * (ta = 0.5 * (rxsq = 1.0 / (xdmy * xdmy)))) * bvalues[2]) >= tst) {
                tk = 2.0;
                for (k = 4; k <= 22; ++k) {
                    t = t * ((tk + (double)fn + 1.0) / (tk + 1.0)) * ((tk + (double)fn) / (tk + 2.0)) * rxsq;
                    dpsifn.trm[dpsifn.k] = t * bvalues[k - 1];
                    if (Math.abs(trm[k]) < tst) break;
                    s += trm[k];
                    tk += 2.0;
                }
            }
            s = (s + t1) * tss;
            if (xinc != 0.0) {
                nx = (int)xinc;
                np = nn + 1;
                if (nx > 100) {
                    dpsifn.nz[0] = 0;
                    dpsifn.ierr[0] = 3;
                    return;
                }
                if (nn == 0) {
                    dpsifn.L20();
                    dpsifn.L30();
                    return;
                }
                xm = xinc - 1.0;
                fx = x + xm;
                for (i = 1; i <= nx; ++i) {
                    dpsifn.trmr[dpsifn.i] = Math.pow(fx, -np);
                    s += trmr[i];
                    fx = x + (xm -= 1.0);
                }
            }
            dpsifn.ans[dpsifn.mm - 1] = s;
            if (fn == 0) {
                dpsifn.L30();
                return;
            }
            for (j = 2; j <= mm; ++j) {
                tss *= xdmy;
                t1 = tt;
                if (--fn != 0) {
                    t1 = tt + 1.0 / (double)fn;
                }
                if (Math.abs(s = (t = (double)(fn + 1) * ta) * bvalues[2]) >= tst) {
                    tk = 4 + fn;
                    for (k = 4; k <= 22; ++k) {
                        dpsifn.trm[dpsifn.k] = trm[k] * (double)(fn + 1) / tk;
                        if (Math.abs(trm[k]) < tst) break;
                        s += trm[k];
                        tk += 2.0;
                    }
                }
                s = (s + t1) * tss;
                if (xinc != 0.0) {
                    if (fn == 0) {
                        dpsifn.L20();
                        dpsifn.L30();
                        return;
                    }
                    xm = xinc - 1.0;
                    fx = x + xm;
                    for (i = 1; i <= nx; ++i) {
                        dpsifn.trmr[dpsifn.i] = trmr[i] * fx;
                        s += trmr[i];
                        fx = x + (xm -= 1.0);
                    }
                }
                dpsifn.ans[dpsifn.mm - dpsifn.j] = s;
                if (fn != 0) continue;
                dpsifn.L30();
            }
        }

        static {
            xln = 0.0;
            trm = new double[23];
            trmr = new double[101];
        }
    }
}

