/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals;

import java.util.BitSet;
import org.renjin.eval.EvalException;
import org.renjin.primitives.matrix.DoubleMatrixBuilder;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class VarianceCalculator {
    private VariableSet x;
    private VariableSet y;
    private DoubleMatrixBuilder result;
    private Method method;
    private MissingStrategy missingStrategy;

    public VarianceCalculator(AtomicVector x, AtomicVector y, int missingStrategy) {
        this.x = new VariableSet(x);
        if (y == Null.INSTANCE) {
            this.y = null;
        } else {
            this.y = new VariableSet(y);
            if (this.x.observations != this.y.observations) {
                throw new EvalException("dimensions not compatible", new Object[0]);
            }
        }
        this.missingStrategy = this.createMissingStrategy(missingStrategy);
    }

    public VarianceCalculator withCovarianceMethod() {
        this.method = new SampleCovariance();
        return this;
    }

    public VarianceCalculator withPearsonCorrelation() {
        this.method = new PearsonCorrelation();
        return this;
    }

    public DoubleVector calculate() {
        if (this.y == null) {
            return this.selfCalculate();
        }
        return this.crossCalculate();
    }

    private DoubleVector selfCalculate() {
        this.result = new DoubleMatrixBuilder(this.x.variables, this.x.variables);
        this.result.setRowNames(this.x.names);
        this.result.setColNames(this.x.names);
        int nVars = this.x.variables;
        for (int i = 0; i != nVars; ++i) {
            this.result.set(i, i, this.method.calculate(this.x.getVariable(i)));
            for (int j = i + 1; j < nVars; ++j) {
                double value = this.method.calculate(this.x.getVariable(i), this.x.getVariable(j));
                this.result.setValue(i, j, value);
                this.result.setValue(j, i, value);
            }
        }
        return (DoubleVector)this.result.build();
    }

    private DoubleVector crossCalculate() {
        this.result = new DoubleMatrixBuilder(this.x.variables, this.y.variables);
        for (int i = 0; i != this.x.variables; ++i) {
            for (int j = 0; j != this.y.variables; ++j) {
                double value = this.method.calculate(this.x.getVariable(i), this.y.getVariable(j));
                this.result.setValue(i, j, value);
            }
        }
        return (DoubleVector)this.result.build();
    }

    private MissingStrategy createMissingStrategy(int index) {
        switch (index) {
            case 1: {
                return new AllObs();
            }
            case 2: {
                return new CompleteObs();
            }
            case 3: {
                return new PairwiseCompleteObs();
            }
            case 4: {
                return new Everything();
            }
            case 5: {
                return new NaOrComplete(this.x, this.y);
            }
        }
        throw new IllegalArgumentException("missingStrategy = " + index);
    }

    private final class NaOrComplete
    implements MissingStrategy {
        private BitSet incomplete;

        public NaOrComplete(VariableSet x, VariableSet y) {
            this.incomplete = new BitSet(x.observations);
            this.markMissing(x);
            this.markMissing(y);
        }

        private void markMissing(VariableSet x) {
            if (x != null) {
                for (int i = 0; i != x.variables; ++i) {
                    Variable variable = x.getVariable(i);
                    for (int j = 0; j != x.observations; ++j) {
                        if (!DoubleVector.isNA(variable.get(j))) continue;
                        this.incomplete.set(j, false);
                    }
                }
            }
        }

        @Override
        public boolean use(double x, double y, int observationIndex) {
            return !this.incomplete.get(observationIndex);
        }
    }

    private final class Everything
    implements MissingStrategy {
        private Everything() {
        }

        @Override
        public boolean use(double x, double y, int observationIndex) {
            return true;
        }
    }

    private final class PairwiseCompleteObs
    implements MissingStrategy {
        private PairwiseCompleteObs() {
        }

        @Override
        public boolean use(double x, double y, int observationIndex) {
            return !DoubleVector.isNA(x) && !DoubleVector.isNA(y);
        }
    }

    private final class CompleteObs
    implements MissingStrategy {
        private CompleteObs() {
        }

        @Override
        public boolean use(double x, double y, int observationIndex) {
            throw new UnsupportedOperationException("nyi");
        }
    }

    private final class AllObs
    implements MissingStrategy {
        public AllObs() {
            if (VarianceCalculator.this.x.hasNA() || VarianceCalculator.this.y != null && VarianceCalculator.this.y.hasNA()) {
                throw new EvalException("missing observation in cov/cor", new Object[0]);
            }
        }

        @Override
        public boolean use(double x, double y, int observationIndex) {
            return true;
        }
    }

    private static interface MissingStrategy {
        public boolean use(double var1, double var3, int var5);
    }

    private class SampleCovariance
    implements Method {
        private SampleCovariance() {
        }

        @Override
        public double calculate(Variable x, Variable y) {
            double sum_x = 0.0;
            double sum_y = 0.0;
            double n = 0.0;
            for (int i = 0; i != x.observations; ++i) {
                double x_i = x.get(i);
                double y_i = y.get(i);
                if (!VarianceCalculator.this.missingStrategy.use(x_i, y_i, i)) continue;
                sum_x += x_i;
                sum_y += y_i;
                n += 1.0;
            }
            double mean_x = sum_x / n;
            double mean_y = sum_y / n;
            double sum_deviates = 0.0;
            for (int i = 0; i != x.observations; ++i) {
                double x_i = x.get(i);
                double y_i = y.get(i);
                if (!VarianceCalculator.this.missingStrategy.use(x_i, y_i, i)) continue;
                sum_deviates += (x_i - mean_x) * (y_i - mean_y);
            }
            return sum_deviates / (n - 1.0);
        }

        @Override
        public double calculate(Variable x) {
            return this.calculate(x, x);
        }
    }

    private class PearsonCorrelation
    implements Method {
        private PearsonCorrelation() {
        }

        @Override
        public double calculate(Variable x, Variable y) {
            double sum_xy = 0.0;
            double sum_x = 0.0;
            double sum_x2 = 0.0;
            double sum_y = 0.0;
            double sum_y2 = 0.0;
            double n = 0.0;
            for (int i = 0; i != x.observations; ++i) {
                double x_i = x.get(i);
                double y_i = y.get(i);
                if (!VarianceCalculator.this.missingStrategy.use(x_i, y_i, i)) continue;
                sum_xy += x_i * y_i;
                sum_x += x_i;
                sum_x2 += x_i * x_i;
                sum_y += y_i;
                sum_y2 += y_i * y_i;
                n += 1.0;
            }
            return (sum_xy - sum_x * sum_y / n) / Math.sqrt(sum_x2 - sum_x * sum_x / n) / Math.sqrt(sum_y2 - sum_y * sum_y / n);
        }

        @Override
        public double calculate(Variable x) {
            return 1.0;
        }
    }

    private static interface Method {
        public double calculate(Variable var1, Variable var2);

        public double calculate(Variable var1);
    }

    private class Variable {
        private Vector vector;
        private int start;
        private int observations;

        public Variable(Vector vector2, int start, int observations) {
            this.vector = vector2;
            this.start = start;
            this.observations = observations;
        }

        public final double get(int i) {
            return this.vector.getElementAsDouble(this.start + i);
        }
    }

    public class VariableSet {
        private AtomicVector vector;
        private int variables;
        private int observations;
        private Vector names = Null.INSTANCE;

        public VariableSet(AtomicVector vector2) {
            this.vector = vector2;
            Vector dim2 = (Vector)vector2.getAttribute(Symbols.DIM);
            if (dim2 == Null.INSTANCE) {
                this.observations = vector2.length();
                this.variables = 1;
            } else {
                if (dim2.length() != 2) {
                    throw new EvalException("must be vector or matrix, not higher-order array", new Object[0]);
                }
                this.observations = dim2.getElementAsInt(0);
                this.variables = dim2.getElementAsInt(1);
                Vector dimNames = vector2.getAttributes().getDimNames();
                if (dimNames != Null.INSTANCE && dimNames.length() == 2) {
                    this.names = (Vector)dimNames.getElementAsSEXP(1);
                }
            }
        }

        public Variable getVariable(int i) {
            return new Variable(this.vector, i * this.observations, this.observations);
        }

        public boolean hasNA() {
            return this.vector.containsNA();
        }
    }
}

