/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class ElementAccess
implements Expression {
    private Expression vector;
    private Expression index;

    public ElementAccess(Expression vector2, Expression index) {
        this.vector = vector2;
        this.index = index;
    }

    public Expression getVector() {
        return this.vector;
    }

    public Expression getIndex() {
        return this.index;
    }

    public String toString() {
        return this.vector + "[" + this.index + "]";
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        Vector vectorValue = (Vector)this.vector.retrieveValue(context, temps);
        Integer indexValue = (Integer)this.index.retrieveValue(context, temps);
        return vectorValue.getElementAsSEXP(indexValue);
    }

    @Override
    public Set<Variable> variables() {
        return Sets.union(this.vector.variables(), this.index.variables());
    }

    @Override
    public ElementAccess replaceVariable(Variable name, Variable newName) {
        return new ElementAccess(this.vector.replaceVariable(name, newName), this.index.replaceVariable(name, newName));
    }

    @Override
    public List<Expression> getChildren() {
        return Arrays.asList(this.vector, this.index);
    }

    @Override
    public void setChild(int i, Expression expr) {
        if (i == 0) {
            this.vector = expr;
        } else if (i == 1) {
            this.index = expr;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitElementAccess(this);
    }

    @Override
    public SEXP getSExpression() {
        throw new UnsupportedOperationException();
    }
}

