/*
 * Decompiled with CFR 0.152.
 */
package io.scif.media.imageioimpl.plugins.jpeg2000;

import io.scif.jj2000.j2k.codestream.reader.HeaderDecoder;
import io.scif.jj2000.j2k.util.FacilityManager;
import io.scif.jj2000.j2k.util.MsgLogger;
import io.scif.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import io.scif.media.imageioimpl.plugins.jpeg2000.I18N;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KReadState;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReader
extends ImageReader
implements MsgLogger {
    private ImageInputStream iis = null;
    private long streamPosition0;
    private boolean gotHeader = false;
    private int width;
    private int height;
    private J2KMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private HeaderDecoder hd;
    private J2KReadState readState = null;
    private boolean logJJ2000Msg = Boolean.getBoolean("io.scif.jj2000.j2k.decoder.log");

    public static void computeRegionsWrapper(ImageReadParam param, boolean allowZeroDestOffset, int srcWidth, int srcHeight, BufferedImage image, Rectangle srcRegion, Rectangle destRegion) {
        if (srcRegion == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
        }
        if (destRegion == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader1"));
        }
        int periodX = 1;
        int periodY = 1;
        int gridX = 0;
        int gridY = 0;
        if (param != null) {
            Rectangle paramSrcRegion = param.getSourceRegion();
            if (paramSrcRegion != null) {
                srcRegion.setBounds(srcRegion.intersection(paramSrcRegion));
            }
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            gridX = param.getSubsamplingXOffset();
            gridY = param.getSubsamplingYOffset();
            srcRegion.translate(gridX, gridY);
            srcRegion.width -= gridX;
            srcRegion.height -= gridY;
            if (allowZeroDestOffset) {
                destRegion.setLocation(param.getDestinationOffset());
            } else {
                Point destOffset = param.getDestinationOffset();
                if (destOffset.x != 0 || destOffset.y != 0) {
                    destRegion.setLocation(param.getDestinationOffset());
                }
            }
        }
        if (destRegion.x < 0) {
            int delta = -destRegion.x * periodX;
            srcRegion.x += delta;
            srcRegion.width -= delta;
            destRegion.x = 0;
        }
        if (destRegion.y < 0) {
            int delta = -destRegion.y * periodY;
            srcRegion.y += delta;
            srcRegion.height -= delta;
            destRegion.y = 0;
        }
        int subsampledWidth = (srcRegion.width + periodX - 1) / periodX;
        int subsampledHeight = (srcRegion.height + periodY - 1) / periodY;
        destRegion.width = subsampledWidth;
        destRegion.height = subsampledHeight;
        if (image != null) {
            int deltaY;
            Rectangle destImageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
            destRegion.setBounds(destRegion.intersection(destImageRect));
            if (destRegion.isEmpty()) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader2"));
            }
            int deltaX = destRegion.x + subsampledWidth - image.getWidth();
            if (deltaX > 0) {
                srcRegion.width -= deltaX * periodX;
            }
            if ((deltaY = destRegion.y + subsampledHeight - image.getHeight()) > 0) {
                srcRegion.height -= deltaY * periodY;
            }
        }
        if (srcRegion.isEmpty() || destRegion.isEmpty()) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader3"));
        }
    }

    public static void checkReadParamBandSettingsWrapper(ImageReadParam param, int numSrcBands, int numDstBands) {
        J2KImageReader.checkReadParamBandSettings(param, numSrcBands, numDstBands);
    }

    static Rectangle getReducedRect(Rectangle r, int maxLevel, int level, int subX, int subY) {
        if (r == null) {
            throw new IllegalArgumentException("r == null!");
        }
        if (maxLevel < 0 || level < 0) {
            throw new IllegalArgumentException("maxLevel < 0 || level < 0!");
        }
        if (level > maxLevel) {
            throw new IllegalArgumentException("level > maxLevel");
        }
        if (level == maxLevel && subX == 1 && subY == 1) {
            return r;
        }
        int divisor = 1 << maxLevel - level;
        int divX = divisor * subX;
        int divY = divisor * subY;
        int x1 = (r.x + divX - 1) / divX;
        int x2 = (r.x + r.width + divX - 1) / divX;
        int y1 = (r.y + divY - 1) / divY;
        int y2 = (r.y + r.height + divY - 1) / divY;
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public void processImageUpdateWrapper(BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        this.processImageUpdate(theImage, minX, minY, width, height, periodX, periodY, bands);
    }

    public void processImageProgressWrapper(float percentageDone) {
        this.processImageProgress(percentageDone);
    }

    public J2KImageReader(ImageReaderSpi originator) {
        super(originator);
        FacilityManager.registerMsgLogger(null, this);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.ignoreMetadata = ignoreMetadata;
        this.iis = (ImageInputStream)input;
        this.imageMetadata = null;
        try {
            this.streamPosition0 = this.iis.getStreamPosition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.height;
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.hd.getTilingOrigin(null).x;
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.hd.getTilingOrigin(null).y;
    }

    public int getTileWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.hd.getNomTileWidth();
    }

    public int getTileHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.hd.getNomTileHeight();
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("J2KImageReader4"));
        }
    }

    public void readHeader() {
        if (this.gotHeader) {
            return;
        }
        if (this.readState == null) {
            try {
                this.iis.seek(this.streamPosition0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.readState = new J2KReadState(this.iis, new J2KImageReadParamJava(this.getDefaultReadParam()), this);
        }
        this.hd = this.readState.getHeader();
        this.gotHeader = true;
        this.width = this.hd.getImgWidth();
        this.height = this.hd.getImgHeight();
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        if (this.readState != null) {
            ArrayList<ImageTypeSpecifier> list = new ArrayList<ImageTypeSpecifier>();
            list.add(new ImageTypeSpecifier(this.readState.getColorModel(), this.readState.getSampleModel()));
            return list.iterator();
        }
        return null;
    }

    public ImageReadParam getDefaultReadParam() {
        return new J2KImageReadParam();
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        if (this.ignoreMetadata) {
            return null;
        }
        if (this.imageMetadata == null) {
            this.iis.mark();
            this.imageMetadata = new J2KMetadata(this.iis, this);
            this.iis.reset();
        }
        return this.imageMetadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.clearAbortRequest();
        this.processImageStarted(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        param = new J2KImageReadParamJava(param);
        if (!this.ignoreMetadata) {
            this.imageMetadata = new J2KMetadata();
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)param, this.imageMetadata, this);
        } else {
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)param, this);
        }
        BufferedImage bi = this.readState.readBufferedImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bi;
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        J2KRenderedImage ri = null;
        this.clearAbortRequest();
        this.processImageStarted(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        param = new J2KImageReadParamJava(param);
        if (!this.ignoreMetadata) {
            if (this.imageMetadata == null) {
                this.imageMetadata = new J2KMetadata();
            }
            ri = new J2KRenderedImage(this.iis, (J2KImageReadParamJava)param, this.imageMetadata, this);
        } else {
            ri = new J2KRenderedImage(this.iis, (J2KImageReadParamJava)param, this);
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return ri;
    }

    public boolean canReadRaster() {
        return true;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return false;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.processImageStarted(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        param = new J2KImageReadParamJava(param);
        if (!this.ignoreMetadata) {
            this.imageMetadata = new J2KMetadata();
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)param, this.imageMetadata, this);
        } else {
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)param, this);
        }
        Raster ras = this.readState.readAsRaster();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return ras;
    }

    public boolean isImageTiled(int imageIndex) {
        this.checkIndex(imageIndex);
        this.readHeader();
        if (this.readState != null) {
            J2KRenderedImage image = new J2KRenderedImage(this.readState);
            return image.getNumXTiles() * image.getNumYTiles() > 0;
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        this.imageMetadata = null;
        this.readState = null;
        System.gc();
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private ImageTypeSpecifier getImageType(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        if (this.readState != null) {
            return new ImageTypeSpecifier(this.readState.getColorModel(), this.readState.getSampleModel());
        }
        return null;
    }

    public void flush() {
    }

    public void println(String str, int flind, int ind) {
        this.printmsg(1, str);
    }

    public void printmsg(int sev, String msg) {
        if (this.logJJ2000Msg) {
            String msgSev;
            switch (sev) {
                case 3: {
                    msgSev = "ERROR";
                    break;
                }
                case 1: {
                    msgSev = "INFO";
                    break;
                }
                case 0: {
                    msgSev = "LOG";
                    break;
                }
                default: {
                    msgSev = "WARNING";
                }
            }
            this.processWarningOccurred("[JJ2000 " + msgSev + "] " + msg);
        }
    }
}

