/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.scijava.log.LogService;

public class JTextAreaWriter
extends Writer {
    JTextArea textArea;
    protected final LogService log;
    ScheduledExecutorService updater = Executors.newScheduledThreadPool(1);
    Vector<String> queue = new Vector();

    public JTextAreaWriter(JTextArea textArea, LogService logService) {
        this.textArea = textArea;
        this.log = logService;
        this.updater.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JTextAreaWriter.this.flushQueue();
            }
        }, 10L, 400L, TimeUnit.MILLISECONDS);
    }

    public void print(String line) {
        this.write(line + "\n");
    }

    @Override
    public void write(int i) {
        this.write(Character.toString((char)i));
    }

    @Override
    public void write(char[] buffer) {
        this.write(new String(buffer));
    }

    @Override
    public void write(char[] buffer, int off, int len) {
        this.write(new String(buffer, off, len));
    }

    @Override
    public void write(String string) {
        this.queue.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue() {
        ArrayList<String> strings;
        Vector<String> vector = this.queue;
        synchronized (vector) {
            if (0 == this.queue.size()) {
                return;
            }
            strings = new ArrayList<String>();
            strings.addAll(this.queue);
            this.queue.clear();
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(s);
        }
        JTextArea jTextArea = this.textArea;
        synchronized (jTextArea) {
            int lineCount = this.textArea.getLineCount();
            if (lineCount > 1100) {
                try {
                    this.textArea.replaceRange("", 0, this.textArea.getLineEndOffset(lineCount - 1000));
                }
                catch (BadLocationException e) {
                    this.log.error((Throwable)e);
                }
            }
            this.textArea.append(sb.toString());
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        }
    }

    @Override
    public void flush() {
        this.flushQueue();
        this.textArea.repaint();
    }

    @Override
    public void close() {
        this.flush();
        this.updater.shutdown();
    }

    public void shutdown() {
        List<Runnable> tasks = this.updater.shutdownNow();
        if (null == tasks) {
            return;
        }
        for (Runnable t : tasks) {
            t.run();
        }
    }

    public void shutdownNow() {
        this.updater.shutdownNow();
    }
}

