/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ImageProcessor;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.util.Util;

public final class LongIntegralImage
implements IntegralImage {
    private final int width;
    private final int height;
    private final int w;
    private final int w1;
    protected final long[] sum;

    LongIntegralImage(int[] pixels, int width, int height) {
        this.width = width;
        this.height = height;
        this.w = width + 1;
        this.w1 = this.w + 1;
        int w2 = this.w + this.w;
        int n = this.w * height + this.w;
        int n1 = n - this.w1;
        int n2 = n1 - this.w + 2;
        this.sum = new long[n];
        int i = 0;
        for (int j = this.w1; j < n; ++j) {
            int end = i + width;
            long s = this.sum[j] = (long)pixels[i];
            ++i;
            ++j;
            while (i < end) {
                this.sum[j] = s += (long)pixels[i];
                ++i;
                ++j;
            }
        }
        for (int j = this.w1; j < w2; j -= n1) {
            int end = j + n2;
            long s = this.sum[j];
            j += this.w;
            while (j < end) {
                this.sum[j] = s += this.sum[j];
                j += this.w;
            }
        }
    }

    LongIntegralImage(long[] sum, int width, int height) {
        this.width = width;
        this.height = height;
        this.w = width + 1;
        this.w1 = this.w + 1;
        this.sum = sum;
    }

    public LongIntegralImage(ImageProcessor ip) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.w = this.width + 1;
        this.w1 = this.w + 1;
        int w2 = this.w + this.w;
        int n = this.w * this.height + this.w;
        int n1 = n - this.w1;
        int n2 = n1 - this.w + 2;
        this.sum = new long[n];
        int i = 0;
        for (int j = this.w1; j < n; ++j) {
            int end = i + this.width;
            long s = this.sum[j] = (long)ip.get(i);
            ++i;
            ++j;
            while (i < end) {
                this.sum[j] = s += (long)ip.get(i);
                ++i;
                ++j;
            }
        }
        for (int j = this.w1; j < w2; j -= n1) {
            int end = j + n2;
            long s = this.sum[j];
            j += this.w;
            while (j < end) {
                this.sum[j] = s += this.sum[j];
                j += this.w;
            }
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final long getLongSum(int x, int y) {
        return this.sum[y * this.w + this.w1 + x];
    }

    public final long getLongSum(int xMin, int yMin, int xMax, int yMax) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        return this.sum[y1w + xMin] + this.sum[y2w + xMax] - this.sum[y1w + xMax] - this.sum[y2w + xMin];
    }

    public final int getSum(int xMin, int yMin, int xMax, int yMax) {
        return (int)this.getLongSum(xMin, yMin, xMax, yMax);
    }

    public final int getScaledSum(int xMin, int yMin, int xMax, int yMax, float scale) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        return Util.roundPos((float)(this.sum[y1w + xMin] + this.sum[y2w + xMax] - this.sum[y1w + xMax] - this.sum[y2w + xMin]) * scale);
    }
}

