/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import mpicbg.ij.integral.AbstractInteractiveBlockFilter;
import mpicbg.ij.integral.BlockStatistics;

public final class InteractiveStandardDeviation
extends AbstractInteractiveBlockFilter {
    private FloatProcessor fp;
    private ImageProcessor ipOriginal;
    private BlockStatistics std;

    protected final void init() {
        this.ipOriginal = this.imp.getProcessor();
        this.fp = this.imp.getType() == 2 ? (FloatProcessor)this.ipOriginal.duplicate() : (FloatProcessor)this.ipOriginal.convertToFloat();
        this.imp.setProcessor((ImageProcessor)this.fp);
        this.std = new BlockStatistics(this.fp);
    }

    protected final void draw() {
        this.std.std(this.blockRadiusX, this.blockRadiusY);
    }

    protected final void showHelp() {
        IJ.showMessage((String)"Interactive Block Standard Deviation", (String)("Click and drag to change the size of the smoothing kernel." + NL + "ENTER - Apply" + NL + "ESC - Cancel"));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            this.canvas.removeKeyListener(this);
            this.window.removeKeyListener((KeyListener)this);
            this.ij.removeKeyListener((KeyListener)this);
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            if (this.imp != null) {
                if (e.getKeyCode() == 27) {
                    this.imp.setProcessor(this.ipOriginal);
                } else if (e.getKeyCode() == 10) {
                    // empty if block
                }
            }
            this.imp.updateAndDraw();
        } else if (e.getKeyCode() == 112) {
            this.showHelp();
        }
    }
}

