/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.ij.integral.IntegralImage;

public final class DoubleIntegralImage
implements IntegralImage {
    private final int width;
    private final int height;
    private final int w;
    private final int w1;
    private final double[] sum;

    DoubleIntegralImage(float[] pixels, int width, int height) {
        this.width = width;
        this.height = height;
        this.w = width + 1;
        this.w1 = this.w + 1;
        int w2 = this.w + this.w;
        int n = this.w * height + this.w;
        int n1 = n - this.w1;
        int n2 = n1 - this.w + 2;
        this.sum = new double[n];
        int i = 0;
        for (int j = this.w1; j < n; ++j) {
            int end = i + width;
            double s = this.sum[j] = (double)pixels[i];
            ++i;
            ++j;
            while (i < end) {
                this.sum[j] = s += (double)pixels[i];
                ++i;
                ++j;
            }
        }
        for (int j = this.w1; j < w2; j -= n1) {
            int end = j + n2;
            double s = this.sum[j];
            j += this.w;
            while (j < end) {
                this.sum[j] = s += this.sum[j];
                j += this.w;
            }
        }
    }

    DoubleIntegralImage(double[] sum, int width, int height) {
        this.width = width;
        this.height = height;
        this.w = width + 1;
        this.w1 = this.w + 1;
        this.sum = sum;
    }

    public DoubleIntegralImage(FloatProcessor fp) {
        this((float[])fp.getPixels(), fp.getWidth(), fp.getHeight());
    }

    public DoubleIntegralImage(ImageProcessor ip) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.w = this.width + 1;
        this.w1 = this.w + 1;
        int w2 = this.w + this.w;
        int n = this.w * this.height + this.w;
        int n1 = n - this.w1;
        int n2 = n1 - this.w + 2;
        this.sum = new double[n];
        int i = 0;
        for (int j = this.w1; j < n; ++j) {
            int end = i + this.width;
            double s = this.sum[j] = (double)ip.getf(i);
            ++i;
            ++j;
            while (i < end) {
                this.sum[j] = s += (double)ip.getf(i);
                ++i;
                ++j;
            }
        }
        for (int j = this.w1; j < w2; j -= n1) {
            int end = j + n2;
            double s = this.sum[j];
            j += this.w;
            while (j < end) {
                this.sum[j] = s += this.sum[j];
                j += this.w;
            }
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getDoubleSum(int x, int y) {
        return this.sum[y * this.w + this.w1 + x];
    }

    public final double getDoubleSum(int xMin, int yMin, int xMax, int yMax) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        return this.sum[y1w + xMin] + this.sum[y2w + xMax] - this.sum[y1w + xMax] - this.sum[y2w + xMin];
    }

    public final int getSum(int xMin, int yMin, int xMax, int yMax) {
        return Float.floatToIntBits((float)this.getDoubleSum(xMin, yMin, xMax, yMax));
    }

    public final int getScaledSum(int xMin, int yMin, int xMax, int yMax, float scale) {
        int y1w = yMin * this.w + this.w1;
        int y2w = yMax * this.w + this.w1;
        return Float.floatToIntBits((float)(this.sum[y1w + xMin] + this.sum[y2w + xMax] - this.sum[y1w + xMax] - this.sum[y2w + xMin]) * scale);
    }

    final double[] getData() {
        return this.sum;
    }

    public final FloatProcessor toProcessor() {
        float[] pixels = new float[this.width * this.height];
        for (int y = 0; y < this.height; ++y) {
            int row = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                pixels[row + x] = (float)this.getDoubleSum(x - 1, y - 1, x, y);
            }
        }
        return new FloatProcessor(this.width, this.height, pixels, null);
    }
}

